﻿---
title: Graphite codec plugin v3.0.6
description: Plugin version: v3.0.6, Released on: 2021-08-12, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-6-plugins-codecs-graphite
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Graphite codec plugin v3.0.6
- Plugin version: v3.0.6
- Released on: 2021-08-12
- [Changelog](https://github.com/logstash-plugins/logstash-codec-graphite/blob/v3.0.6/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-graphite-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-graphite). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This codec will encode and decode Graphite formated lines.

## Graphite Codec Configuration Options


| Setting                                                                    | Input type                                                      | Required |
|----------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`exclude_metrics`](#v3.0.6-plugins-codecs-graphite-exclude_metrics)       | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`fields_are_metrics`](#v3.0.6-plugins-codecs-graphite-fields_are_metrics) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`include_metrics`](#v3.0.6-plugins-codecs-graphite-include_metrics)       | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`metrics`](#v3.0.6-plugins-codecs-graphite-metrics)                       | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`metrics_format`](#v3.0.6-plugins-codecs-graphite-metrics_format)         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `exclude_metrics`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["%{[^}]+}"]`

Exclude regex matched metric names, by default exclude unresolved %{field} strings

### `fields_are_metrics`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Indicate that the event @fields should be treated as metrics and will be sent as is to graphite

### `include_metrics`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[".*"]`

Include only regex matched metric names

### `metrics`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

The metric(s) to use. This supports dynamic strings like `%{host}` for metric names and also for values. This is a hash field with key of the metric name, value of the metric value. Example:
```
    [ "%{host}/uptime", "%{uptime_1m}" ]
```

The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

### `metrics_format`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"*"`

Defines format of the metric string. The placeholder `*` will be replaced with the name of the actual metric. This supports dynamic strings like `%{host}`.
```
    metrics_format => "%{host}.foo.bar.*.sum"
```

If no metrics_format is defined the name of the metric will be used as fallback.