﻿---
title: Loggly output plugin v3.0.5
description: Plugin version: v3.0.5, Released on: 2018-05-09, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-5-plugins-outputs-loggly
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Loggly output plugin v3.0.5
- Plugin version: v3.0.5
- Released on: 2018-05-09
- [Changelog](https://github.com/logstash-plugins/logstash-output-loggly/blob/v3.0.5/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-loggly-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-loggly). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Got a loggly account? Use logstash to ship logs to Loggly!
This is most useful so you can use logstash to parse and structure your logs and ship structured, json events to your account at Loggly.
To use this, you’ll need to use a Loggly input with type *http* and *json logging* enabled.

## Loggly Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.5-plugins-outputs-loggly-common-options) described later.

| Setting                                                           | Input type                                                        | Required |
|-------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`can_retry`](#v3.0.5-plugins-outputs-loggly-can_retry)           | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`host`](#v3.0.5-plugins-outputs-loggly-host)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`key`](#v3.0.5-plugins-outputs-loggly-key)                       | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |
| [`proto`](#v3.0.5-plugins-outputs-loggly-proto)                   | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`proxy_host`](#v3.0.5-plugins-outputs-loggly-proxy_host)         | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`proxy_password`](#v3.0.5-plugins-outputs-loggly-proxy_password) | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`proxy_port`](#v3.0.5-plugins-outputs-loggly-proxy_port)         | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`proxy_user`](#v3.0.5-plugins-outputs-loggly-proxy_user)         | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`retry_count`](#v3.0.5-plugins-outputs-loggly-retry_count)       | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`tag`](#v3.0.5-plugins-outputs-loggly-tag)                       | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |

Also see [Common options](#v3.0.5-plugins-outputs-loggly-common-options) for a list of options supported by all output plugins.

### `can_retry`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Can Retry. Setting this value true helps user to send multiple retry attempts if the first request fails

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logs-01.loggly.com"`

The hostname to send logs to. This should target the loggly http input server which is usually "logs-01.loggly.com" (Gen2 account). See Loggly HTTP endpoint documentation at 

### `key`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The loggly http customer token to use for sending. You can find yours in "Source Setup", under "Customer Tokens".
You can use `%{foo}` field lookups here if you need to pull the api key from the event. This is mainly aimed at multitenant hosting providers who want to offer shipping a customer’s logs to that customer’s loggly account.

### `proto`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"http"`

Should the log action be sent over https instead of plain http

### `proxy_host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Proxy Host

### `proxy_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- Default value is `""`

Proxy Password

### `proxy_port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

Proxy Port

### `proxy_user`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Proxy Username

### `retry_count`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5`

Retry count. It may be possible that the request may timeout due to slow Internet connection if such condition appears, retry_count helps in retrying request for multiple times It will try to submit request until retry_count and then halt

### `tag`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

Loggly Tag Tag helps you to find your logs in the Loggly dashboard easily You can make a search in Loggly using tag as "tag:logstash-contrib" or the tag set by you in the config file.
You can use %{somefield} to allow for custom tag values. Helpful for leveraging Loggly source groups. 

## Common options

These configuration options are supported by all output plugins:

| Setting                                                         | Input type                                                      | Required |
|-----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.5-plugins-outputs-loggly-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.5-plugins-outputs-loggly-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.5-plugins-outputs-loggly-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 loggly outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  loggly {
    id => "my_plugin_id"
  }
}
```