﻿---
title: Juggernaut output plugin v3.0.4
description: Plugin version: v3.0.4, Released on: 2017-08-16, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-4-plugins-outputs-juggernaut
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Juggernaut output plugin v3.0.4
- Plugin version: v3.0.4
- Released on: 2017-08-16
- [Changelog](https://github.com/logstash-plugins/logstash-output-juggernaut/blob/v3.0.4/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-juggernaut-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-juggernaut). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Push messages to the juggernaut websockets server:
- 

Wraps Websockets and supports other methods (including xhr longpolling) This is basically, just an extension of the redis output (Juggernaut pulls messages from redis). But it pushes messages to a particular channel and formats the messages in the way juggernaut expects.

## Juggernaut Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.4-plugins-outputs-juggernaut-common-options) described later.

| Setting                                                               | Input type                                                        | Required |
|-----------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`channels`](#v3.0.4-plugins-outputs-juggernaut-channels)             | [array](/docs/reference/logstash/plugins/value-types#array)       | Yes      |
| [`db`](#v3.0.4-plugins-outputs-juggernaut-db)                         | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`host`](#v3.0.4-plugins-outputs-juggernaut-host)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`message_format`](#v3.0.4-plugins-outputs-juggernaut-message_format) | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`password`](#v3.0.4-plugins-outputs-juggernaut-password)             | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`port`](#v3.0.4-plugins-outputs-juggernaut-port)                     | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`timeout`](#v3.0.4-plugins-outputs-juggernaut-timeout)               | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |

Also see [Common options](#v3.0.4-plugins-outputs-juggernaut-common-options) for a list of options supported by all output plugins.

### `channels`

- This is a required setting.
- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

List of channels to which to publish. Dynamic names are valid here, for example `logstash-%{type}`.

### `db`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0`

The redis database number.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"127.0.0.1"`

The hostname of the redis server to which juggernaut is listening.

### `message_format`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

How should the message be formatted before pushing to the websocket.

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Password to authenticate with. There is no authentication by default.

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `6379`

The port to connect on.

### `timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5`

Redis initial connection timeout in seconds.

## Common options

These configuration options are supported by all output plugins:

| Setting                                                             | Input type                                                      | Required |
|---------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.4-plugins-outputs-juggernaut-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.4-plugins-outputs-juggernaut-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.4-plugins-outputs-juggernaut-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 juggernaut outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  juggernaut {
    id => "my_plugin_id"
  }
}
```