﻿---
title: Relp input plugin v3.0.4
description: Plugin version: v3.0.4, Released on: 2018-04-06, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-4-plugins-inputs-relp
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Relp input plugin v3.0.4
- Plugin version: v3.0.4
- Released on: 2018-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-input-relp/blob/v3.0.4/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-relp-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-relp). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Read RELP events over a TCP socket.
For more information about RELP, see 
This protocol implements application-level acknowledgements to help protect against message loss.
Message acks only function as far as messages being put into the queue for filters; anything lost after that point will not be retransmitted

## Relp Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.4-plugins-inputs-relp-common-options) described later.

| Setting                                                                | Input type                                                        | Required |
|------------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`host`](#v3.0.4-plugins-inputs-relp-host)                             | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`port`](#v3.0.4-plugins-inputs-relp-port)                             | [number](/docs/reference/logstash/plugins/value-types#number)     | Yes      |
| [`ssl_cacert`](#v3.0.4-plugins-inputs-relp-ssl_cacert)                 | a valid filesystem path                                           | No       |
| [`ssl_cert`](#v3.0.4-plugins-inputs-relp-ssl_cert)                     | a valid filesystem path                                           | No       |
| [`ssl_enable`](#v3.0.4-plugins-inputs-relp-ssl_enable)                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`ssl_key`](#v3.0.4-plugins-inputs-relp-ssl_key)                       | a valid filesystem path                                           | No       |
| [`ssl_key_passphrase`](#v3.0.4-plugins-inputs-relp-ssl_key_passphrase) | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`ssl_verify`](#v3.0.4-plugins-inputs-relp-ssl_verify)                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |

Also see [Common options](#v3.0.4-plugins-inputs-relp-common-options) for a list of options supported by all input plugins.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"0.0.0.0"`

The address to listen on.

### `port`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

The port to listen on.

### `ssl_cacert`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The SSL CA certificate, chainfile or CA path. The system CA path is automatically included.

### `ssl_cert`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL certificate path

### `ssl_enable`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Enable SSL (must be set for other `ssl_` options to take effect).

### `ssl_key`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL key path

### `ssl_key_passphrase`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- Default value is `nil`

SSL key passphrase

### `ssl_verify`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Verify the identity of the other end of the SSL connection against the CA. For input, sets the field `sslsubject` to that of the client certificate.

## Common options

These configuration options are supported by all input plugins:

| Setting                                                      | Input type                                                      | Required |
|--------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.0.4-plugins-inputs-relp-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.0.4-plugins-inputs-relp-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.4-plugins-inputs-relp-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.4-plugins-inputs-relp-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.0.4-plugins-inputs-relp-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.0.4-plugins-inputs-relp-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 relp inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  relp {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.