﻿---
title: Irc input plugin v3.0.4
description: Plugin version: v3.0.4, Released on: 2017-08-15, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-4-plugins-inputs-irc
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Irc input plugin v3.0.4
- Plugin version: v3.0.4
- Released on: 2017-08-15
- [Changelog](https://github.com/logstash-plugins/logstash-input-irc/blob/v3.0.4/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-irc-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-irc). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Read events from an IRC Server.

## Irc Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.4-plugins-inputs-irc-common-options) described later.

| Setting                                                       | Input type                                                        | Required |
|---------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`catch_all`](#v3.0.4-plugins-inputs-irc-catch_all)           | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`channels`](#v3.0.4-plugins-inputs-irc-channels)             | [array](/docs/reference/logstash/plugins/value-types#array)       | Yes      |
| [`get_stats`](#v3.0.4-plugins-inputs-irc-get_stats)           | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`host`](#v3.0.4-plugins-inputs-irc-host)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |
| [`nick`](#v3.0.4-plugins-inputs-irc-nick)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`password`](#v3.0.4-plugins-inputs-irc-password)             | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`port`](#v3.0.4-plugins-inputs-irc-port)                     | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`real`](#v3.0.4-plugins-inputs-irc-real)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`secure`](#v3.0.4-plugins-inputs-irc-secure)                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`stats_interval`](#v3.0.4-plugins-inputs-irc-stats_interval) | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`user`](#v3.0.4-plugins-inputs-irc-user)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |

Also see [Common options](#v3.0.4-plugins-inputs-irc-common-options) for a list of options supported by all input plugins.

### `catch_all`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Catch all IRC channel/user events not just channel messages

### `channels`

- This is a required setting.
- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Channels to join and read messages from.
These should be full channel names including the *#* symbol, such as "#logstash".
For passworded channels, add a space and the channel password, such as "#logstash password".

### `get_stats`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Gather and send user counts for channels - this requires catch_all and will force it

### `host`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Host of the IRC Server to connect to.

### `nick`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

IRC Nickname

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

IRC Server password

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `6667`

Port for the IRC Server

### `real`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

IRC Real name

### `secure`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Set this to true to enable SSL.

### `stats_interval`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5`

How often in minutes to get the user count stats

### `user`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

IRC Username

## Common options

These configuration options are supported by all input plugins:

| Setting                                                     | Input type                                                      | Required |
|-------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.0.4-plugins-inputs-irc-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.0.4-plugins-inputs-irc-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.4-plugins-inputs-irc-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.4-plugins-inputs-irc-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.0.4-plugins-inputs-irc-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.0.4-plugins-inputs-irc-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 irc inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  irc {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.