﻿---
title: Riak output plugin v3.0.3
description: Plugin version: v3.0.3, Released on: 2017-11-13, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-3-plugins-outputs-riak
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Riak output plugin v3.0.3
- Plugin version: v3.0.3
- Released on: 2017-11-13
- [Changelog](https://github.com/logstash-plugins/logstash-output-riak/blob/v3.0.3/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-riak-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-riak). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Riak is a distributed k/v store from Basho. It’s based on the Dynamo model.

## Riak Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.3-plugins-outputs-riak-common-options) described later.

| Setting                                                       | Input type                                                                             | Required |
|---------------------------------------------------------------|----------------------------------------------------------------------------------------|----------|
| [`bucket`](#v3.0.3-plugins-outputs-riak-bucket)               | [array](/docs/reference/logstash/plugins/value-types#array)                            | No       |
| [`bucket_props`](#v3.0.3-plugins-outputs-riak-bucket_props)   | [hash](/docs/reference/logstash/plugins/value-types#hash)                              | No       |
| [`enable_search`](#v3.0.3-plugins-outputs-riak-enable_search) | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                        | No       |
| [`enable_ssl`](#v3.0.3-plugins-outputs-riak-enable_ssl)       | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                        | No       |
| [`indices`](#v3.0.3-plugins-outputs-riak-indices)             | [array](/docs/reference/logstash/plugins/value-types#array)                            | No       |
| [`key_name`](#v3.0.3-plugins-outputs-riak-key_name)           | [string](/docs/reference/logstash/plugins/value-types#string)                          | No       |
| [`nodes`](#v3.0.3-plugins-outputs-riak-nodes)                 | [hash](/docs/reference/logstash/plugins/value-types#hash)                              | No       |
| [`proto`](#v3.0.3-plugins-outputs-riak-proto)                 | [string](/docs/reference/logstash/plugins/value-types#string), one of `["http", "pb"]` | No       |
| [`ssl_opts`](#v3.0.3-plugins-outputs-riak-ssl_opts)           | [hash](/docs/reference/logstash/plugins/value-types#hash)                              | No       |

Also see [Common options](#v3.0.3-plugins-outputs-riak-common-options) for a list of options supported by all output plugins.

### `bucket`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["logstash-%{+YYYY.MM.dd}"]`

The bucket name to write events to Expansion is supported here as values are passed through event.sprintf Multiple buckets can be specified here but any bucket-specific settings defined apply to ALL the buckets.

### `bucket_props`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

Bucket properties (NYI) Logstash hash of properties for the bucket i.e.
```
    bucket_props => {
        "r" => "one"
        "w" => "one"
        "dw", "one
     }
or
[source,ruby]
    bucket_props => { "n_val" => "3" }
Properties will be passed as-is
```


### `enable_search`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Search Enable search on the bucket defined above

### `enable_ssl`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

SSL Enable SSL

### `indices`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Indices Array of fields to add 2i on e.g.
```
    `indices => ["source_host", "type"]
Off by default as not everyone runs eleveldb
```


### `key_name`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The event key name variables are valid here.
Choose this carefully. Best to let riak decide.

### `nodes`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{"localhost"=>"8098"}`

The nodes of your Riak cluster This can be a single host or a Logstash hash of node/port pairs e.g
```
    {
        "node1" => "8098"
        "node2" => "8098"
    }
```


### `proto`

- Value can be any of: `http`, `pb`
- Default value is `"http"`

The protocol to use HTTP or ProtoBuf Applies to ALL backends listed above No mix and match

### `ssl_opts`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

SSL Options Options for SSL connections Only applied if SSL is enabled Logstash hash that maps to the riak-client options here:  You’ll likely want something like this:
```
    ssl_opts => {
       "pem" => "/etc/riak.pem"
       "ca_path" => "/usr/share/certificates"
    }
```

Per the riak client docs, the above sample options will turn on SSL `VERIFY_PEER`

## Common options

These configuration options are supported by all output plugins:

| Setting                                                       | Input type                                                      | Required |
|---------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.3-plugins-outputs-riak-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.3-plugins-outputs-riak-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.3-plugins-outputs-riak-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 riak outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  riak {
    id => "my_plugin_id"
  }
}
```