﻿---
title: Redmine output plugin v3.0.3
description: Plugin version: v3.0.3, Released on: 2017-11-13, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-3-plugins-outputs-redmine
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Redmine output plugin v3.0.3
- Plugin version: v3.0.3
- Released on: 2017-11-13
- [Changelog](https://github.com/logstash-plugins/logstash-output-redmine/blob/v3.0.3/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-redmine-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-redmine). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

The redmine output is used to create a ticket via the API redmine.
It send a POST request in a JSON format and use TOKEN authentication
—Exemple of use—
```
 output {
   redmine {
     url => "http://redmineserver.tld"
     token => 'token'
     project_id => 200
     tracker_id => 1
     status_id => 3
     priority_id => 2
     subject => "Error ... detected"
   }
 }
```


## Redmine Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.3-plugins-outputs-redmine-common-options) described later.

| Setting                                                                | Input type                                                      | Required |
|------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`assigned_to_id`](#v3.0.3-plugins-outputs-redmine-assigned_to_id)     | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`categorie_id`](#v3.0.3-plugins-outputs-redmine-categorie_id)         | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`description`](#v3.0.3-plugins-outputs-redmine-description)           | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`fixed_version_id`](#v3.0.3-plugins-outputs-redmine-fixed_version_id) | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`parent_issue_id`](#v3.0.3-plugins-outputs-redmine-parent_issue_id)   | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`priority_id`](#v3.0.3-plugins-outputs-redmine-priority_id)           | [number](/docs/reference/logstash/plugins/value-types#number)   | Yes      |
| [`project_id`](#v3.0.3-plugins-outputs-redmine-project_id)             | [number](/docs/reference/logstash/plugins/value-types#number)   | Yes      |
| [`ssl`](#v3.0.3-plugins-outputs-redmine-ssl)                           | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`status_id`](#v3.0.3-plugins-outputs-redmine-status_id)               | [number](/docs/reference/logstash/plugins/value-types#number)   | Yes      |
| [`subject`](#v3.0.3-plugins-outputs-redmine-subject)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`token`](#v3.0.3-plugins-outputs-redmine-token)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`tracker_id`](#v3.0.3-plugins-outputs-redmine-tracker_id)             | [number](/docs/reference/logstash/plugins/value-types#number)   | Yes      |
| [`url`](#v3.0.3-plugins-outputs-redmine-url)                           | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |

Also see [Common options](#v3.0.3-plugins-outputs-redmine-common-options) for a list of options supported by all output plugins.

### `assigned_to_id`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `nil`

redmine issue assigned_to not required for post_issue

### `categorie_id`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `nil`

not required for post_issue

### `description`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"%{message}"`

redmine issue description required

### `fixed_version_id`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `nil`

redmine issue fixed_version_id

### `parent_issue_id`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `nil`

redmine issue parent_issue_id not required for post_issue

### `priority_id`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

redmine issue priority_id required

### `project_id`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

redmine issue projet_id required

### `ssl`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`


### `status_id`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

redmine issue status_id required

### `subject`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"%{host}"`

redmine issue subject required

### `token`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

redmine token user used for authentication

### `tracker_id`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

redmine issue tracker_id required

### `url`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

host of redmine app value format : ** - Not add */issues* at end

## Common options

These configuration options are supported by all output plugins:

| Setting                                                          | Input type                                                      | Required |
|------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.3-plugins-outputs-redmine-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.3-plugins-outputs-redmine-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.3-plugins-outputs-redmine-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 redmine outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  redmine {
    id => "my_plugin_id"
  }
}
```