﻿---
title: Nagios_nsca output plugin v3.0.3
description: Plugin version: v3.0.3, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-3-plugins-outputs-nagios_nsca
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Nagios_nsca output plugin v3.0.3
- Plugin version: v3.0.3
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-output-nagios_nsca/blob/v3.0.3/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-nagios_nsca-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-nagios_nsca). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

The nagios_nsca output is used for sending passive check results to Nagios through the NSCA protocol.
This is useful if your Nagios server is not the same as the source host from where you want to send logs or alerts. If you only have one server, this output is probably overkill # for you, take a look at the *nagios* output instead.
Here is a sample config using the nagios_nsca output:
```
    output {
      nagios_nsca {
        # specify the hostname or ip of your nagios server
        host => "nagios.example.com"
```

```
    # specify the port to connect to
    port => 5667
  }
}
```


## Nagios_nsca Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.3-plugins-outputs-nagios_nsca-common-options) described later.

| Setting                                                                    | Input type                                                    | Required |
|----------------------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`host`](#v3.0.3-plugins-outputs-nagios_nsca-host)                         | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`message_format`](#v3.0.3-plugins-outputs-nagios_nsca-message_format)     | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`nagios_host`](#v3.0.3-plugins-outputs-nagios_nsca-nagios_host)           | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`nagios_service`](#v3.0.3-plugins-outputs-nagios_nsca-nagios_service)     | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`nagios_status`](#v3.0.3-plugins-outputs-nagios_nsca-nagios_status)       | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`port`](#v3.0.3-plugins-outputs-nagios_nsca-port)                         | [number](/docs/reference/logstash/plugins/value-types#number) | No       |
| [`send_nsca_bin`](#v3.0.3-plugins-outputs-nagios_nsca-send_nsca_bin)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`send_nsca_config`](#v3.0.3-plugins-outputs-nagios_nsca-send_nsca_config) | a valid filesystem path                                       | No       |

Also see [Common options](#v3.0.3-plugins-outputs-nagios_nsca-common-options) for a list of options supported by all output plugins.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"localhost"`

The nagios host or IP to send logs to. It should have a NSCA daemon running.

### `message_format`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"%{@timestamp} %{host}: %{message}"`

The format to use when writing events to nagios. This value supports any string and can include `%{name}` and other dynamic strings.

### `nagios_host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"%{host}"`

The nagios *host* you want to submit a passive check result to. This parameter accepts interpolation, e.g. you can use `@source_host` or other logstash internal variables.

### `nagios_service`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"LOGSTASH"`

The nagios *service* you want to submit a passive check result to. This parameter accepts interpolation, e.g. you can use `@source_host` or other logstash internal variables.

### `nagios_status`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The status to send to nagios. Should be 0 = OK, 1 = WARNING, 2 = CRITICAL, 3 = UNKNOWN

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5667`

The port where the NSCA daemon on the nagios host listens.

### `send_nsca_bin`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"/usr/sbin/send_nsca"`

The path to the *send_nsca* binary on the local host.

### `send_nsca_config`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The path to the send_nsca config file on the local host. Leave blank if you don’t want to provide a config file.

## Common options

These configuration options are supported by all output plugins:

| Setting                                                              | Input type                                                      | Required |
|----------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.3-plugins-outputs-nagios_nsca-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.3-plugins-outputs-nagios_nsca-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.3-plugins-outputs-nagios_nsca-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 nagios_nsca outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  nagios_nsca {
    id => "my_plugin_id"
  }
}
```