﻿---
title: Irc output plugin v3.0.3
description: Plugin version: v3.0.3, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-3-plugins-outputs-irc
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Irc output plugin v3.0.3
- Plugin version: v3.0.3
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-output-irc/blob/v3.0.3/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-irc-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-irc). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Write events to IRC

## Irc Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.3-plugins-outputs-irc-common-options) described later.

| Setting                                                                  | Input type                                                        | Required |
|--------------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`channels`](#v3.0.3-plugins-outputs-irc-channels)                       | [array](/docs/reference/logstash/plugins/value-types#array)       | Yes      |
| [`format`](#v3.0.3-plugins-outputs-irc-format)                           | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`host`](#v3.0.3-plugins-outputs-irc-host)                               | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |
| [`messages_per_second`](#v3.0.3-plugins-outputs-irc-messages_per_second) | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`nick`](#v3.0.3-plugins-outputs-irc-nick)                               | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`password`](#v3.0.3-plugins-outputs-irc-password)                       | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`port`](#v3.0.3-plugins-outputs-irc-port)                               | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`post_string`](#v3.0.3-plugins-outputs-irc-post_string)                 | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`pre_string`](#v3.0.3-plugins-outputs-irc-pre_string)                   | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`real`](#v3.0.3-plugins-outputs-irc-real)                               | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`secure`](#v3.0.3-plugins-outputs-irc-secure)                           | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`user`](#v3.0.3-plugins-outputs-irc-user)                               | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |

Also see [Common options](#v3.0.3-plugins-outputs-irc-common-options) for a list of options supported by all output plugins.

### `channels`

- This is a required setting.
- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Channels to broadcast to.
These should be full channel names including the *#* symbol, such as "#logstash".

### `format`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"%{message}"`

Message format to send, event tokens are usable here

### `host`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Address of the host to connect to

### `messages_per_second`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0.5`

Limit the rate of messages sent to IRC in messages per second.

### `nick`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

IRC Nickname

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

IRC server password

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `6667`

Port on host to connect to.

### `post_string`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Static string after event

### `pre_string`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Static string before event

### `real`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

IRC Real name

### `secure`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Set this to true to enable SSL.

### `user`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

IRC Username

## Common options

These configuration options are supported by all output plugins:

| Setting                                                      | Input type                                                      | Required |
|--------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.3-plugins-outputs-irc-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.3-plugins-outputs-irc-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.3-plugins-outputs-irc-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 irc outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  irc {
    id => "my_plugin_id"
  }
}
```