﻿---
title: Librato output plugin v3.0.2
description: Plugin version: v3.0.2, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-2-plugins-outputs-librato
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Librato output plugin v3.0.2
- Plugin version: v3.0.2
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-output-librato/blob/v3.0.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-librato-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-librato). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output lets you send metrics, annotations, and alerts to Librato based on Logstash events
This is VERY experimental and inefficient right now.

## Librato Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.2-plugins-outputs-librato-common-options) described later.

| Setting                                                    | Input type                                                    | Required |
|------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`account_id`](#v3.0.2-plugins-outputs-librato-account_id) | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`annotation`](#v3.0.2-plugins-outputs-librato-annotation) | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`api_token`](#v3.0.2-plugins-outputs-librato-api_token)   | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`batch_size`](#v3.0.2-plugins-outputs-librato-batch_size) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`counter`](#v3.0.2-plugins-outputs-librato-counter)       | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`gauge`](#v3.0.2-plugins-outputs-librato-gauge)           | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |

Also see [Common options](#v3.0.2-plugins-outputs-librato-common-options) for a list of options supported by all output plugins.

### `account_id`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

This output lets you send metrics, annotations and alerts to Librato based on Logstash events
This is VERY experimental and inefficient right now. Your Librato account usually an email address

### `annotation`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Annotations Registers an annotation with Librato The only required field is `title` and `name`. `start_time` and `end_time` will be set to `event.get("@timestamp").to_i` You can add any other optional annotation values as well. All values will be passed through `event.sprintf`
Example:
```
  {
      "title" => "Logstash event on %{host}"
      "name" => "logstash_stream"
  }
or
[source,ruby]
   {
      "title" => "Logstash event"
      "description" => "%{message}"
      "name" => "logstash_stream"
   }
```


### `api_token`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Your Librato API Token

### `batch_size`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"10"`

Batch size Number of events to batch up before sending to Librato.

### `counter`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Counters Send data to Librato as a counter
Example:
```
    {
        "value" => "1"
        "source" => "%{host}"
        "name" => "messages_received"
    }
```

Additionally, you can override the `measure_time` for the event. Must be a unix timestamp:
```
    {
        "value" => "1"
        "source" => "%{host}"
        "name" => "messages_received"
        "measure_time" => "%{my_unixtime_field}"
    }
Default is to use the event's timestamp
```


### `gauge`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Gauges Send data to Librato as a gauge
Example:
```
    {
        "value" => "%{bytes_received}"
        "source" => "%{host}"
        "name" => "apache_bytes"
    }
Additionally, you can override the `measure_time` for the event. Must be a unix timestamp:
[source,ruby]
    {
        "value" => "%{bytes_received}"
        "source" => "%{host}"
        "name" => "apache_bytes"
        "measure_time" => "%{my_unixtime_field}
    }
Default is to use the event's timestamp
```


## Common options

These configuration options are supported by all output plugins:

| Setting                                                          | Input type                                                      | Required |
|------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.2-plugins-outputs-librato-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.2-plugins-outputs-librato-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.2-plugins-outputs-librato-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 librato outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  librato {
    id => "my_plugin_id"
  }
}
```