﻿---
title: Salesforce input plugin v3.0.2
description: Plugin version: v3.0.2, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-2-plugins-inputs-salesforce
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Salesforce input plugin v3.0.2
- Plugin version: v3.0.2
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-input-salesforce/blob/v3.0.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-salesforce-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-salesforce). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This Logstash input plugin allows you to query Salesforce using SOQL and puts the results into Logstash, one row per event. You can configure it to pull entire sObjects or only specific fields.
This input plugin will stop after all the results of the query are processed and will need to be re-run to fetch new results. It does not utilize the streaming API.
In order to use this plugin, you will need to create a new SFDC Application using oauth. More details can be found here: 
You will also need a username, password, and security token for your salesforce instance. More details for generating a token can be found here: 
In addition to specifying an sObject, you can also supply a list of API fields that will be used in the SOQL query.

## Example

This example prints all the Salesforce Opportunities to standard out
```
input {
  salesforce {
    client_id => 'OAUTH CLIENT ID FROM YOUR SFDC APP'
    client_secret => 'OAUTH CLIENT SECRET FROM YOUR SFDC APP'
    username => 'email@example.com'
    password => 'super-secret'
    security_token => 'SECURITY TOKEN FOR THIS USER'
    sfdc_object_name => 'Opportunity'
  }
}

output {
  stdout {
    codec => rubydebug
  }
}
```


## Salesforce Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.2-plugins-inputs-salesforce-common-options) described later.

| Setting                                                                  | Input type                                                      | Required |
|--------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`api_version`](#v3.0.2-plugins-inputs-salesforce-api_version)           | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`client_id`](#v3.0.2-plugins-inputs-salesforce-client_id)               | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`client_secret`](#v3.0.2-plugins-inputs-salesforce-client_secret)       | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`password`](#v3.0.2-plugins-inputs-salesforce-password)                 | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`security_token`](#v3.0.2-plugins-inputs-salesforce-security_token)     | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`sfdc_fields`](#v3.0.2-plugins-inputs-salesforce-sfdc_fields)           | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`sfdc_filters`](#v3.0.2-plugins-inputs-salesforce-sfdc_filters)         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`sfdc_object_name`](#v3.0.2-plugins-inputs-salesforce-sfdc_object_name) | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`to_underscores`](#v3.0.2-plugins-inputs-salesforce-to_underscores)     | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`use_test_sandbox`](#v3.0.2-plugins-inputs-salesforce-use_test_sandbox) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`username`](#v3.0.2-plugins-inputs-salesforce-username)                 | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |

Also see [Common options](#v3.0.2-plugins-inputs-salesforce-common-options) for a list of options supported by all input plugins.

### `api_version`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

By default, this uses the default Restforce API version. To override this, set this to something like "32.0" for example

### `client_id`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Consumer Key for authentication. You must set up a new SFDC connected app with oath to use this output. More information can be found here: 

### `client_secret`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Consumer Secret from your oauth enabled connected app

### `password`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The password used to login to sfdc

### `security_token`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The security token for this account. For more information about generting a security token, see: 

### `sfdc_fields`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

These are the field names to return in the Salesforce query If this is empty, all fields are returned.

### `sfdc_filters`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

These options will be added to the WHERE clause in the SOQL statement. Additional fields can be filtered on by adding field1 = value1 AND field2 = value2 AND…

### `sfdc_object_name`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The name of the salesforce object you are creating or updating

### `to_underscores`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Setting this to true will convert SFDC’s NamedFields*c to named_fields*c

### `use_test_sandbox`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Set this to true to connect to a sandbox sfdc instance logging in through test.salesforce.com

### `username`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

A valid salesforce user name, usually your email address. Used for authentication and will be the user all objects are created or modified by

## Common options

These configuration options are supported by all input plugins:

| Setting                                                            | Input type                                                      | Required |
|--------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.0.2-plugins-inputs-salesforce-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.0.2-plugins-inputs-salesforce-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.2-plugins-inputs-salesforce-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.2-plugins-inputs-salesforce-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.0.2-plugins-inputs-salesforce-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.0.2-plugins-inputs-salesforce-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 salesforce inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  salesforce {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.