﻿---
title: Elastic Workplace Search output plugin v3.0.1
description: A component of the elastic_enterprise_search integration plugin, Integration version: v3.0.1, Released on: 2025-01-03, Changelog. For other versions,...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-1-plugins-outputs-elastic_workplace_search
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Elastic Workplace Search output plugin v3.0.1
- A component of the [elastic_enterprise_search integration plugin](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-elastic_enterprise_search-index)
- Integration version: v3.0.1
- Released on: 2025-01-03
- [Changelog](https://github.com/logstash-plugins/logstash-integration-elastic_enterprise_search/blob/v3.0.1/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-elastic_workplace_search-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-integration-elastic_enterprise_search). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output lets you send events to the [Elastic Workplace Search](https://www.elastic.co/workplace-search) solution. On receiving a batch of events from the Logstash pipeline, the plugin converts the events into documents and uses the Workplace Search bulk API to index multiple events in one request.
Workplace Search doesn’t allow fields to begin with `@timestamp`. By default the `@timestamp` and `@version` fields will be removed from each event before the event is sent to Workplace Search. If you want to keep the `@timestamp` field, you can use the [timestamp_destination](#v3.0.1-plugins-outputs-elastic_workplace_search-timestamp_destination) option to store the timestamp in a different field.
This gem does not support codec customization.

## Workplace Search Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.1-plugins-outputs-elastic_workplace_search-common-options) described later.

| Setting                                                                                                       | Input type                                                                               | Required |
|---------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|----------|
| [`access_token`](#v3.0.1-plugins-outputs-elastic_workplace_search-access_token)                               | [password](/docs/reference/logstash/plugins/value-types#password)                        | Yes      |
| [`document_id`](#v3.0.1-plugins-outputs-elastic_workplace_search-document_id)                                 | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`source`](#v3.0.1-plugins-outputs-elastic_workplace_search-source)                                           | [string](/docs/reference/logstash/plugins/value-types#string)                            | Yes      |
| [`ssl_certificate_authorities`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_certificate_authorities) | list of [path](/docs/reference/logstash/plugins/value-types#path)                        | No       |
| [`ssl_cipher_suites`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_cipher_suites)                     | list of [string](/docs/reference/logstash/plugins/value-types#string)                    | No       |
| [`ssl_supported_protocols`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_supported_protocols)         | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`ssl_truststore_password`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_truststore_password)         | [password](/docs/reference/logstash/plugins/value-types#password)                        | No       |
| [`ssl_truststore_path`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_truststore_path)                 | [path](/docs/reference/logstash/plugins/value-types#path)                                | No       |
| [`ssl_truststore_type`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_truststore_type)                 | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`ssl_verification_mode`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_verification_mode)             | [string](/docs/reference/logstash/plugins/value-types#string), one of `["full", "none"]` | No       |
| [`timestamp_destination`](#v3.0.1-plugins-outputs-elastic_workplace_search-timestamp_destination)             | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`url`](#v3.0.1-plugins-outputs-elastic_workplace_search-url)                                                 | [string](/docs/reference/logstash/plugins/value-types#string)                            | Yes      |

Also see [Common options](#v3.0.1-plugins-outputs-elastic_workplace_search-common-options) for a list of options supported by all output plugins.

### `access_token`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value

The source access token. Visit the source overview page in the Workplace Search dashboard to find the token associated with your source.

### `document_id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

The id for workplace search documents. This can be an interpolated value like `myapp-%{sequence_id}`. Reusing ids will cause documents to be rewritten.

### `source`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

The ID of the source you created in Workplace Search. The `source` field supports [sprintf format](https://www.elastic.co/guide/en/logstash/current/event-dependent-configuration.html#sprintf) to allow the source ID to be derived from a field value from each event, for example `%{source_id}`.
Invalid source IDs cause ingestion to stop until the field value can be resolved into a valid source ID. This situation can happen if the interpolated field value resolves to a value without a matching source, or, if the field is missing from the event and cannot be resolved at all.
Consider adding a "default" source type in the configuration to catch errors if the field is missing from the event.
Example:
```
input {
  stdin {
    codec => json
  }
}

filter {
  if ![source_id] {
    mutate {
      add_field => {"source_id" => "default"}
    }
  }
}

output {
  elastic_workplace_search {
    source => "%{[source_id]}"
    access_token => "abracadabra"
    url => "http://workplace.example.com:3002"
  }
}
```


### `ssl_certificate_authorities`

- Value type is a list of [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting

The .cer or .pem files to validate the server’s certificate.
You cannot use this setting and [`ssl_truststore_path`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_truststore_path) at the same time.

### `ssl_cipher_suites`

- Value type is a list of [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting

The list of cipher suites to use, listed by priorities. Supported cipher suites vary depending on the Java and protocol versions.

### `ssl_supported_protocols`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Allowed values are: `'TLSv1.1'`, `'TLSv1.2'`, `'TLSv1.3'`
- Default depends on the JDK being used. With up-to-date Logstash, the default is `['TLSv1.2', 'TLSv1.3']`. `'TLSv1.1'` is not considered secure and is only provided for legacy applications.

List of allowed SSL/TLS versions to use when establishing a connection to the Elasticsearch cluster.
For Java 8 `'TLSv1.3'` is supported only since **8u262** (AdoptOpenJDK), but requires that you set the `LS_JAVA_OPTS="-Djdk.tls.client.protocols=TLSv1.3"` system property in Logstash.
If you configure the plugin to use `'TLSv1.1'` on any recent JVM, such as the one packaged with Logstash, the protocol is disabled by default and needs to be enabled manually by changing `jdk.tls.disabledAlgorithms` in the **$JDK_HOME/conf/security/java.security** configuration file. That is, `TLSv1.1` needs to be removed from the list.

### `ssl_truststore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Set the truststore password

### `ssl_truststore_path`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The truststore to validate the server’s certificate. It can be either `.jks` or `.p12`.
You cannot use this setting and [`ssl_certificate_authorities`](#v3.0.1-plugins-outputs-elastic_workplace_search-ssl_certificate_authorities) at the same time.

### `ssl_truststore_type`

- Value can be any of: `jks`, `pkcs12`
- If not provided, the value will be inferred from the truststore filename.

The format of the truststore file. It must be either `jks` or `pkcs12`.

### `ssl_verification_mode`

- Value can be any of: `full`, `none`
- Default value is `full`

Defines how to verify the certificates presented by another party in the TLS connection:
`full` validates that the server certificate has an issue date that’s within the not_before and not_after dates; chains to a trusted Certificate Authority (CA), and has a hostname or IP address that matches the names within the certificate.
`none` performs no certificate validation.
Setting certificate verification to `none` disables many security benefits of SSL/TLS, which is very dangerous. For more information on disabling certificate verification please read 

### `timestamp_destination`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

Where to move the value from the `@timestamp` field.
All Logstash events contain a `@timestamp` field. Workplace Search doesn’t support fields starting with `@timestamp`, and by default, the `@timestamp` field will be deleted.
To keep the timestamp field, set this value to the name of the field where you want `@timestamp` copied.

### `url`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `http://localhost:3002`

The value of the API endpoint in the form of a URL.
**Examples**
On premise instance:
`http://workplace.example.com:3002`
Elastic Cloud instance:
`https://7c455f508468426cb53912be65548117.ent-search.eu-west-1.aws.cloud.es.io`

## Common options

These configuration options are supported by all output plugins:

| Setting                                                                           | Input type                                                      | Required |
|-----------------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`enable_metric`](#v3.0.1-plugins-outputs-elastic_workplace_search-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.1-plugins-outputs-elastic_workplace_search-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 elastic_workplace_search outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  elastic_workplace_search {
    id => "my_plugin_id"
  }
}
```