﻿---
title: Slack output plugin v2.1.1
description: Plugin version: v2.1.1, Released on: 2018-04-06, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v2-1-1-plugins-outputs-slack
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Slack output plugin v2.1.1
- Plugin version: v2.1.1
- Released on: 2018-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-output-slack/blob/v2.1.1/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-slack-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-slack). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Write events to Slack.

## Slack Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v2.1.1-plugins-outputs-slack-common-options) described later.

| Setting                                                    | Input type                                                    | Required |
|------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`attachments`](#v2.1.1-plugins-outputs-slack-attachments) | [array](/docs/reference/logstash/plugins/value-types#array)   | No       |
| [`channel`](#v2.1.1-plugins-outputs-slack-channel)         | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`format`](#v2.1.1-plugins-outputs-slack-format)           | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`icon_emoji`](#v2.1.1-plugins-outputs-slack-icon_emoji)   | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`icon_url`](#v2.1.1-plugins-outputs-slack-icon_url)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`url`](#v2.1.1-plugins-outputs-slack-url)                 | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`username`](#v2.1.1-plugins-outputs-slack-username)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |

Also see [Common options](#v2.1.1-plugins-outputs-slack-common-options) for a list of options supported by all output plugins.

### `attachments`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Attachments array as described 

### `channel`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The channel to post to

### `format`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"%{message}"`

The text to post in slack

### `icon_emoji`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Emoji icon to use

### `icon_url`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Icon URL to use

### `url`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The incoming webhook URI needed to post a message

### `username`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The username to use for posting

## Common options

These configuration options are supported by all output plugins:

| Setting                                                        | Input type                                                      | Required |
|----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v2.1.1-plugins-outputs-slack-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v2.1.1-plugins-outputs-slack-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v2.1.1-plugins-outputs-slack-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 slack outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  slack {
    id => "my_plugin_id"
  }
}
```