﻿---
title: Elastic Workplace Search output plugin v2.1.0
description: Plugin version: v2.1.0, Released on: 2021-05-18, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v2-1-0-plugins-outputs-elastic_workplace_search
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Elastic Workplace Search output plugin v2.1.0
- Plugin version: v2.1.0
- Released on: 2021-05-18
- [Changelog](https://github.com/logstash-plugins/logstash-integration-elastic_enterprise_search/blob/v2.1.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-elastic_workplace_search-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-elastic_workplace_search). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output lets you send events to the Elastic Workplace Search solution. On receiving a batch of events from the Logstash pipeline, the plugin converts the events into documents and uses the Workplace Search bulk API to index multiple events in one request.
Workplace Search doesn’t allow fields to begin with `@timestamp`. By default the `@timestamp` and `@version` fields will be removed from each event before the event is sent to Workplace Search. If you want to keep the `@timestamp` field, you can use the [timestamp_destination](#v2.1.0-plugins-outputs-elastic_workplace_search-timestamp_destination) option to store the timestamp in a different field.
This gem does not support codec customization.

## Workplace Search Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v2.1.0-plugins-outputs-elastic_workplace_search-common-options) described later.

| Setting                                                                                           | Input type                                                        | Required |
|---------------------------------------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`access_token`](#v2.1.0-plugins-outputs-elastic_workplace_search-access_token)                   | [password](/docs/reference/logstash/plugins/value-types#password) | Yes      |
| [`document_id`](#v2.1.0-plugins-outputs-elastic_workplace_search-document_id)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`source`](#v2.1.0-plugins-outputs-elastic_workplace_search-source)                               | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |
| [`timestamp_destination`](#v2.1.0-plugins-outputs-elastic_workplace_search-timestamp_destination) | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`url`](#v2.1.0-plugins-outputs-elastic_workplace_search-url)                                     | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |

Also see [Common options](#v2.1.0-plugins-outputs-elastic_workplace_search-common-options) for a list of options supported by all output plugins.

### `access_token`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value

The source access token. Visit the source overview page in the Workplace Search dashboard to find the token associated with your source.

### `document_id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

The id for workplace search documents. This can be an interpolated value like `myapp-%{sequence_id}`. Reusing ids will cause documents to be rewritten.

### `source`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

The ID of the source you created in Workplace Search. The `source` field supports [sprintf format](https://www.elastic.co/guide/en/logstash/current/event-dependent-configuration.html#sprintf) to allow the source ID to be derived from a field value from each event, for example `%{source_id}`.
Invalid source IDs cause ingestion to stop until the field value can be resolved into a valid source ID. This situation can happen if the interpolated field value resolves to a value without a matching source, or, if the field is missing from the event and cannot be resolved at all.
Consider adding a "default" source type in the configuration to catch errors if the field is missing from the event.
Example:
```
input {
  stdin {
    codec => json
  }
}

filter {
  if ![source_id] {
    mutate {
      add_field => {"source_id" => "default"}
    }
  }
}

output {
  elastic_workplace_search {
    source => "%{[source_id]}"
  }
}
```


### `timestamp_destination`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

Where to move the value from the `@timestamp` field.
All Logstash events contain a `@timestamp` field. Workplace Search doesn’t support fields starting with `@timestamp`, and by default, the `@timestamp` field will be deleted.
To keep the timestamp field, set this value to the name of the field where you want `@timestamp` copied.

### `url`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

The value of the API endpoint in the form of a URL.

## Common options

These configuration options are supported by all output plugins:

| Setting                                                                           | Input type                                                      | Required |
|-----------------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`enable_metric`](#v2.1.0-plugins-outputs-elastic_workplace_search-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v2.1.0-plugins-outputs-elastic_workplace_search-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 elastic_workplace_search outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  elastic_workplace_search {
    id => "my_plugin_id"
  }
}
```