﻿---
title: Kinesis input plugin v2.1.0
description: Plugin version: v2.1.0, Released on: 2019-02-15, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v2-1-0-plugins-inputs-kinesis
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Kinesis input plugin v2.1.0
- Plugin version: v2.1.0
- Released on: 2019-02-15
- [Changelog](https://github.com/logstash-plugins/logstash-input-kinesis/blob/v2.1.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-kinesis-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-kinesis). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Receive events through an AWS Kinesis stream.
This input plugin uses the Java Kinesis Client Library underneath, so the documentation at  will be useful.
AWS credentials can be specified either through environment variables, or an IAM instance role. The library uses a DynamoDB table for worker coordination, so you’ll need to grant access to that as well as to the Kinesis stream. The DynamoDB table has the same name as the `application_name` configuration option, which defaults to "logstash".
The library can optionally also send worker statistics to CloudWatch.

## Kinesis Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v2.1.0-plugins-inputs-kinesis-common-options) described later.

| Setting                                                                                     | Input type                                                                                  | Required |
|---------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------|----------|
| [`application_name`](#v2.1.0-plugins-inputs-kinesis-application_name)                       | [string](/docs/reference/logstash/plugins/value-types#string)                               | No       |
| [`checkpoint_interval_seconds`](#v2.1.0-plugins-inputs-kinesis-checkpoint_interval_seconds) | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`kinesis_stream_name`](#v2.1.0-plugins-inputs-kinesis-kinesis_stream_name)                 | [string](/docs/reference/logstash/plugins/value-types#string)                               | Yes      |
| [`metrics`](#v2.1.0-plugins-inputs-kinesis-metrics)                                         | [string](/docs/reference/logstash/plugins/value-types#string), one of `[nil, "cloudwatch"]` | No       |
| [`profile`](#v2.1.0-plugins-inputs-kinesis-profile)                                         | [string](/docs/reference/logstash/plugins/value-types#string)                               | No       |
| [`region`](#v2.1.0-plugins-inputs-kinesis-region)                                           | [string](/docs/reference/logstash/plugins/value-types#string)                               | No       |
| [`role_arn`](#v2.1.0-plugins-inputs-kinesis-role_arn)                                       | [string](/docs/reference/logstash/plugins/value-types#string)                               | No       |
| [`role_session_name`](#v2.1.0-plugins-inputs-kinesis-role_session_name)                     | [string](/docs/reference/logstash/plugins/value-types#string)                               | No       |

Also see [Common options](#v2.1.0-plugins-inputs-kinesis-common-options) for a list of options supported by all input plugins.

### `application_name`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

The application name used for the dynamodb coordination table. Must be unique for this kinesis stream.

### `checkpoint_interval_seconds`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `60`

How many seconds between worker checkpoints to dynamodb.

### `kinesis_stream_name`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The kinesis stream name.

### `metrics`

- Value can be any of: ``, `cloudwatch`
- Default value is `nil`

Worker metric tracking. By default this is disabled, set it to "cloudwatch" to enable the cloudwatch integration in the Kinesis Client Library.

### `profile`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The AWS profile name for authentication. This ensures that the `~/.aws/credentials` AWS auth provider is used. By default this is empty and the default chain will be used.

### `region`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"us-east-1"`

The AWS region for Kinesis, DynamoDB, and CloudWatch (if enabled)

### `role_arn`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The AWS role to assume. This can be used, for example, to access a Kinesis stream in a different AWS account. This role will be assumed after the default credentials or profile credentials are created. By default this is empty and a role will not be assumed.

### `role_session_name`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `logstash`

Session name to use when assuming an IAM role. This is recorded in CloudTrail logs for example.

## Common options

These configuration options are supported by all input plugins:

| Setting                                                         | Input type                                                      | Required |
|-----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v2.1.0-plugins-inputs-kinesis-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v2.1.0-plugins-inputs-kinesis-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v2.1.0-plugins-inputs-kinesis-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v2.1.0-plugins-inputs-kinesis-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v2.1.0-plugins-inputs-kinesis-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v2.1.0-plugins-inputs-kinesis-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 kinesis inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  kinesis {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.