﻿---
title: Rackspace output plugin v2.0.5
description: Plugin version: v2.0.5, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v2-0-5-plugins-outputs-rackspace
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Rackspace output plugin v2.0.5
- Plugin version: v2.0.5
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-output-rackspace/blob/v2.0.5/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-rackspace-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-rackspace). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Sends events to a Rackspace Cloud Queue service.

## Rackspace Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v2.0.5-plugins-outputs-rackspace-common-options) described later.

| Setting                                                  | Input type                                                    | Required |
|----------------------------------------------------------|---------------------------------------------------------------|----------|
| [`api_key`](#v2.0.5-plugins-outputs-rackspace-api_key)   | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`queue`](#v2.0.5-plugins-outputs-rackspace-queue)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`region`](#v2.0.5-plugins-outputs-rackspace-region)     | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`ttl`](#v2.0.5-plugins-outputs-rackspace-ttl)           | [number](/docs/reference/logstash/plugins/value-types#number) | No       |
| [`username`](#v2.0.5-plugins-outputs-rackspace-username) | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |

Also see [Common options](#v2.0.5-plugins-outputs-rackspace-common-options) for a list of options supported by all output plugins.

### `api_key`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Rackspace Cloud API Key

### `queue`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

Rackspace Queue Name

### `region`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"dfw"`

Rackspace region ord, dfw, lon, syd, etc

### `ttl`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `360`

time for item to live in queue

### `username`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Rackspace Cloud Username

## Common options

These configuration options are supported by all output plugins:

| Setting                                                            | Input type                                                      | Required |
|--------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v2.0.5-plugins-outputs-rackspace-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v2.0.5-plugins-outputs-rackspace-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v2.0.5-plugins-outputs-rackspace-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 rackspace outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  rackspace {
    id => "my_plugin_id"
  }
}
```