﻿---
title: Neo4j output plugin v2.0.5
description: Plugin version: v2.0.5, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v2-0-5-plugins-outputs-neo4j
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Neo4j output plugin v2.0.5
- Plugin version: v2.0.5
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-output-neo4j/blob/v2.0.5/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-neo4j-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-neo4j). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

The neo4j output.

## Neo4j Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v2.0.5-plugins-outputs-neo4j-common-options) described later.

| Setting                                      | Input type                                                    | Required |
|----------------------------------------------|---------------------------------------------------------------|----------|
| [`path`](#v2.0.5-plugins-outputs-neo4j-path) | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |

Also see [Common options](#v2.0.5-plugins-outputs-neo4j-common-options) for a list of options supported by all output plugins.

### `path`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The path within your file system where the neo4j database is located

## Common options

These configuration options are supported by all output plugins:

| Setting                                                        | Input type                                                      | Required |
|----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v2.0.5-plugins-outputs-neo4j-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v2.0.5-plugins-outputs-neo4j-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v2.0.5-plugins-outputs-neo4j-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 neo4j outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  neo4j {
    id => "my_plugin_id"
  }
}
```