﻿---
title: Monasca_log_api output plugin v2.0.0
description: Plugin version: v2.0.0, Released on: 2019-08-28, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v2-0-0-plugins-outputs-monasca_log_api
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Monasca_log_api output plugin v2.0.0
- Plugin version: v2.0.0
- Released on: 2019-08-28
- [Changelog](https://github.com/logstash-plugins/logstash-output-monasca_log_api/blob/v2.0.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-monasca_log_api-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-monasca_log_api). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

relative requirements This Logstash Output plugin, sends events to monasca-api. It authenticates against keystone and gets a token. The token is used to authenticate against the monasca-api and send log events.

## Monasca_log_api Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v2.0.0-plugins-outputs-monasca_log_api-common-options) described later.

| Setting                                                                                        | Input type                                                      | Required |
|------------------------------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`delay`](#v2.0.0-plugins-outputs-monasca_log_api-delay)                                       | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`dimensions`](#v2.0.0-plugins-outputs-monasca_log_api-dimensions)                             | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`elapsed_time_sec`](#v2.0.0-plugins-outputs-monasca_log_api-elapsed_time_sec)                 | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`keystone_api_insecure`](#v2.0.0-plugins-outputs-monasca_log_api-keystone_api_insecure)       | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`keystone_api_url`](#v2.0.0-plugins-outputs-monasca_log_api-keystone_api_url)                 | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`max_data_size_kb`](#v2.0.0-plugins-outputs-monasca_log_api-max_data_size_kb)                 | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`monasca_log_api_insecure`](#v2.0.0-plugins-outputs-monasca_log_api-monasca_log_api_insecure) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`monasca_log_api_url`](#v2.0.0-plugins-outputs-monasca_log_api-monasca_log_api_url)           | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`num_of_logs`](#v2.0.0-plugins-outputs-monasca_log_api-num_of_logs)                           | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`password`](#v2.0.0-plugins-outputs-monasca_log_api-password)                                 | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`project_domain_name`](#v2.0.0-plugins-outputs-monasca_log_api-project_domain_name)           | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`project_name`](#v2.0.0-plugins-outputs-monasca_log_api-project_name)                         | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`user_domain_name`](#v2.0.0-plugins-outputs-monasca_log_api-user_domain_name)                 | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`username`](#v2.0.0-plugins-outputs-monasca_log_api-username)                                 | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |

Also see [Common options](#v2.0.0-plugins-outputs-monasca_log_api-common-options) for a list of options supported by all output plugins.

### `delay`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10`


### `dimensions`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

global dimensions

### `elapsed_time_sec`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `30`


### `keystone_api_insecure`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`


### `keystone_api_url`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

keystone configuration

### `max_data_size_kb`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5120`


### `monasca_log_api_insecure`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`


### `monasca_log_api_url`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

monasca-log-api configuration

### `num_of_logs`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `125`


### `password`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.


### `project_domain_name`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.


### `project_name`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.


### `user_domain_name`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.


### `username`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.


## Common options

These configuration options are supported by all output plugins:

| Setting                                                                  | Input type                                                      | Required |
|--------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v2.0.0-plugins-outputs-monasca_log_api-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v2.0.0-plugins-outputs-monasca_log_api-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v2.0.0-plugins-outputs-monasca_log_api-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"json"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 monasca_log_api outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  monasca_log_api {
    id => "my_plugin_id"
  }
}
```