﻿---
title: HTTP filter plugin v1.1.0
description: Plugin version: v1.1.0, Released on: 2021-12-03, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v1-1-0-plugins-filters-http
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# HTTP filter plugin v1.1.0
- Plugin version: v1.1.0
- Released on: 2021-12-03
- [Changelog](https://github.com/logstash-plugins/logstash-filter-http/blob/v1.1.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/filter-http-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-filter-http). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

The HTTP filter provides integration with external web services/REST APIs.

## HTTP Filter Configuration Options

This plugin supports the following configuration options plus the [Common options](#v1.1.0-plugins-filters-http-common-options) described later.

| Setting                                                         | Input type                                                    | Required |
|-----------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`body`](#v1.1.0-plugins-filters-http-body)                     | String, Array or Hash                                         | No       |
| [`body_format`](#v1.1.0-plugins-filters-http-body_format)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`headers`](#v1.1.0-plugins-filters-http-headers)               | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`query`](#v1.1.0-plugins-filters-http-query)                   | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`target_body`](#v1.1.0-plugins-filters-http-target_body)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`target_headers`](#v1.1.0-plugins-filters-http-target_headers) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`url`](#v1.1.0-plugins-filters-http-url)                       | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`verb`](#v1.1.0-plugins-filters-http-verb)                     | [string](/docs/reference/logstash/plugins/value-types#string) | No       |

There are also multiple configuration options related to the HTTP connectivity:

| Setting                                                                               | Input type                                                        | Required |
|---------------------------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`automatic_retries`](#v1.1.0-plugins-filters-http-automatic_retries)                 | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`cacert`](#v1.1.0-plugins-filters-http-cacert)                                       | a valid filesystem path                                           | No       |
| [`client_cert`](#v1.1.0-plugins-filters-http-client_cert)                             | a valid filesystem path                                           | No       |
| [`client_key`](#v1.1.0-plugins-filters-http-client_key)                               | a valid filesystem path                                           | No       |
| [`connect_timeout`](#v1.1.0-plugins-filters-http-connect_timeout)                     | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`cookies`](#v1.1.0-plugins-filters-http-cookies)                                     | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`follow_redirects`](#v1.1.0-plugins-filters-http-follow_redirects)                   | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`keepalive`](#v1.1.0-plugins-filters-http-keepalive)                                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`keystore`](#v1.1.0-plugins-filters-http-keystore)                                   | a valid filesystem path                                           | No       |
| [`keystore_password`](#v1.1.0-plugins-filters-http-keystore_password)                 | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`keystore_type`](#v1.1.0-plugins-filters-http-keystore_type)                         | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`password`](#v1.1.0-plugins-filters-http-password)                                   | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`pool_max`](#v1.1.0-plugins-filters-http-pool_max)                                   | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`pool_max_per_route`](#v1.1.0-plugins-filters-http-pool_max_per_route)               | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`proxy`](#v1.1.0-plugins-filters-http-proxy)                                         | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`request_timeout`](#v1.1.0-plugins-filters-http-request_timeout)                     | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`retry_non_idempotent`](#v1.1.0-plugins-filters-http-retry_non_idempotent)           | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`socket_timeout`](#v1.1.0-plugins-filters-http-socket_timeout)                       | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`truststore`](#v1.1.0-plugins-filters-http-truststore)                               | a valid filesystem path                                           | No       |
| [`truststore_password`](#v1.1.0-plugins-filters-http-truststore_password)             | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`truststore_type`](#v1.1.0-plugins-filters-http-truststore_type)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`user`](#v1.1.0-plugins-filters-http-user)                                           | [string](/docs/reference/logstash/plugins/value-types#string)     | no       |
| [`validate_after_inactivity`](#v1.1.0-plugins-filters-http-validate_after_inactivity) | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |

Also see [Common options](#v1.1.0-plugins-filters-http-common-options) for a list of options supported by all filter plugins.

### `body`

- Value type can be a [string](/docs/reference/logstash/plugins/value-types#string), [number](/docs/reference/logstash/plugins/value-types#number), [array](/docs/reference/logstash/plugins/value-types#array) or [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value

The body of the HTTP request to be sent.

### `body_format`

- Value type can be either `"json"` or `"text"`
- Default value is `"text"`

If set to `"json"` the body will be serialized as JSON. Otherwise it is sent as is.

### `headers`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value

The HTTP headers to be sent in the request. Both the names of the headers and their values can reference values from event fields.

### `query`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value

Define the query string parameters (key-value pairs) to be sent in the HTTP request.

### `target_body`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value

Define the target field for placing the body of the HTTP response. If this setting is omitted, the data will be stored in the "body" field.

### `target_headers`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value

Define the target field for placing the headers of the HTTP response. If this setting is omitted, the data will be stored in the "headers" field.

### `url`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value

The URL to send the request to. The value can be fetched from event fields.

### `verb`

- Value type can be either `"GET"`, `"HEAD"`, `"PATCH"`, `"DELETE"`, `"POST"`, `"PUT"`
- Default value is `"GET"`

The verb to be used for the HTTP request.

## HTTP Filter Connectivity Options


### `automatic_retries`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`

How many times should the client retry a failing URL. We highly recommend NOT setting this value to zero if keepalive is enabled. Some servers incorrectly end keepalives early requiring a retry! Note: if `retry_non_idempotent` is set only GET, HEAD, PUT, DELETE, OPTIONS, and TRACE requests will be retried.

### `cacert`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

If you need to use a custom X.509 CA (.pem certs) specify the path to that here

### `client_cert`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

If you’d like to use a client certificate (note, most people don’t want this) set the path to the x509 cert here

### `client_key`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

If you’re using a client certificate specify the path to the encryption key here

### `connect_timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10`

Timeout (in seconds) to wait for a connection to be established. Default is `10s`

### `cookies`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Enable cookie support. With this enabled the client will persist cookies across requests as a normal web browser would. Enabled by default

### `follow_redirects`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Should redirects be followed? Defaults to `true`

### `keepalive`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Turn this on to enable HTTP keepalive support. We highly recommend setting `automatic_retries` to at least one with this to fix interactions with broken keepalive implementations.

### `keystore`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

If you need to use a custom keystore (`.jks`) specify that here. This does not work with .pem keys!

### `keystore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Specify the keystore password here. Note, most .jks files created with keytool require a password!

### `keystore_type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"JKS"`

Specify the keystore type here. One of `JKS` or `PKCS12`. Default is `JKS`

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Password to be used in conjunction with the username for HTTP authentication.

### `pool_max`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `50`

Max number of concurrent connections. Defaults to `50`

### `pool_max_per_route`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `25`

Max number of concurrent connections to a single host. Defaults to `25`

### `proxy`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

If you’d like to use an HTTP proxy . This supports multiple configuration syntaxes:
1. Proxy host in form: `http://proxy.org:1234`
2. Proxy host in form: `{host => "proxy.org", port => 80, scheme => 'http', user => 'username@host', password => 'password'}`
3. Proxy host in form: `{url => 'http://proxy.org:1234', user => 'username@host', password => 'password'}`


### `request_timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `60`

Timeout (in seconds) for the entire request.

### `retry_non_idempotent`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

If `automatic_retries` is enabled this will cause non-idempotent HTTP verbs (such as POST) to be retried.

### `socket_timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10`

Timeout (in seconds) to wait for data on the socket. Default is `10s`

### `truststore`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

If you need to use a custom truststore (`.jks`) specify that here. This does not work with .pem certs!

### `truststore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Specify the truststore password here. Note, most .jks files created with keytool require a password!

### `truststore_type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"JKS"`

Specify the truststore type here. One of `JKS` or `PKCS12`. Default is `JKS`

### `user`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Username to use with HTTP authentication for ALL requests. Note that you can also set this per-URL. If you set this you must also set the `password` option.

### `validate_after_inactivity`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `200`

How long to wait before checking for a stale connection to determine if a keepalive request is needed. Consider setting this value lower than the default, possibly to 0, if you get connection errors regularly.
This client is based on Apache Commons. Here’s how the [Apache Commons documentation](https://hc.apache.org/httpcomponents-client-ga/httpclient/apidocs/org/apache/http/impl/conn/PoolingHttpClientConnectionManager.html#setValidateAfterInactivity(int)) describes this option: "Defines period of inactivity in milliseconds after which persistent connections must be re-validated prior to being leased to the consumer. Non-positive value passed to this method disables connection validation. This check helps detect connections that have become stale (half-closed) while kept inactive in the pool."

## Common options

These configuration options are supported by all filter plugins:

| Setting                                                         | Input type                                                      | Required |
|-----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v1.1.0-plugins-filters-http-add_field)           | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`add_tag`](#v1.1.0-plugins-filters-http-add_tag)               | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`enable_metric`](#v1.1.0-plugins-filters-http-enable_metric)   | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v1.1.0-plugins-filters-http-id)                         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`periodic_flush`](#v1.1.0-plugins-filters-http-periodic_flush) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`remove_field`](#v1.1.0-plugins-filters-http-remove_field)     | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`remove_tag`](#v1.1.0-plugins-filters-http-remove_tag)         | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

If this filter is successful, add any arbitrary fields to this event. Field names can be dynamic and include parts of the event using the `%{field}`.
Example:
```
    filter {
      http {
        add_field => { "foo_%{somefield}" => "Hello world, from %{host}" }
      }
    }
```

```
    # You can also add multiple fields at once:
    filter {
      http {
        add_field => {
          "foo_%{somefield}" => "Hello world, from %{host}"
          "new_field" => "new_static_value"
        }
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add field `foo_hello` if it is present, with the value above and the `%{host}` piece replaced with that value from the event. The second example would also add a hardcoded field.

### `add_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, add arbitrary tags to the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      http {
        add_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also add multiple tags at once:
    filter {
      http {
        add_tag => [ "foo_%{somefield}", "taggedy_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add a tag `foo_hello` (and the second example would of course add a `taggedy_tag` tag).

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 http filters. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
    filter {
      http {
        id => "ABC"
      }
    }
```


### `periodic_flush`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Call the filter flush method at regular interval. Optional.

### `remove_field`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary fields from this event. Fields names can be dynamic and include parts of the event using the %{field} Example:
```
    filter {
      http {
        remove_field => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple fields at once:
    filter {
      http {
        remove_field => [ "foo_%{somefield}", "my_extraneous_field" ]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the field with name `foo_hello` if it is present. The second example would remove an additional, non-dynamic field.

### `remove_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary tags from the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      http {
        remove_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple tags at once:
    filter {
      http {
        remove_tag => [ "foo_%{somefield}", "sad_unwanted_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the tag `foo_hello` if it is present. The second example would remove a sad, unwanted tag as well.