﻿---
title: Logstash Integration Plugin v0.0.2
description: Plugin version: v0.0.2, Released on: 2023-09-27, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v0-0-2-plugins-integrations-logstash
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Logstash Integration Plugin v0.0.2
- Plugin version: v0.0.2
- Released on: 2023-09-27
- [Changelog](https://github.com/logstash-plugins/logstash-integration-logstash/blob/v0.0.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-logstash-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-integration-logstash). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

The Logstash Integration Plugin provides integrated plugins for sending events from one Logstash to another:
- [Logstash Output Plugin](https://www.elastic.co/guide/en/logstash/current/plugins-outputs-logstash.html)
- [Logstash Input Plugin](https://www.elastic.co/guide/en/logstash/current/plugins-inputs-logstash.html)


### High-level concepts

You can configure a `logstash` output to send events to a `logstash` input is in another pipeline that is running in a different process or on a different host.
To do so, you should first configure the downstream pipeline with a `logstash` input plugin, bound to an available port so that it can listen for inbound connections. Security is enabled by default, so you will need to either provide identity material or disable SSL.
You will need a TCP route from the upstream pipeline to the interface that the downstream pipeline is bound to.
```
input {
  logstash {
    port => 8080
   
    ssl_keystore_path      => "/path/to/identity.p12"
    ssl_keystore_password  => "${SSL_IDENTITY_PASSWORD}"
  }
}
```

Once the downstream pipeline is configured and running, you may send events from any number of upstream pipelines by adding a `logstash` output plugin that points to the downstream input. You may need to configure SSL to trust the certificates presented by the downstream input plugin.
```
output {
  logstash {
    host => "10.0.0.123"
    port => 8080
   
    ssl_truststore_path => "/path/to/truststore.p12"
    ssl_truststore_password => "${SSL_TRUST_PASSWORD}"
  }
}
```