﻿---
title: Using Logstash with Elastic integrations
description: You can take advantage of the extensive, built-in capabilities of Elastic Integrations--such as managing data collection, transformation, and visualization—and...
url: https://www.elastic.co/docs/reference/logstash/using-logstash-with-elastic-integrations
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud on Kubernetes
  - Elasticsearch
  - Logstash
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Using Logstash with Elastic integrations
You can take advantage of the extensive, built-in capabilities of Elastic Integrations--such as managing data collection, transformation, and visualization—and then use Logstash for additional data processing and output options. Logstash can further expand capabilities for use cases where you need additional processing, or if you need your data delivered to multiple destinations.

## Elastic Integrations: ingesting to visualizing

[Elastic Integrations](https://www.elastic.co/docs/reference/integrations) provide quick, end-to-end solutions for:
- ingesting data from a variety of data sources,
- ensuring compliance with the [Elastic Common Schema (ECS)](https://www.elastic.co/docs/reference/ecs),
- getting the data into the Elastic Stack, and
- visualizing it with purpose-built dashboards.

Integrations are available for [popular services and platforms](https://www.elastic.co/docs/reference/integrations/all_integrations), such as Nginx, AWS, and MongoDB, as well as many generic input types like log files. Each integration includes pre-packaged assets to help reduce the time between ingest and insights.
To see available integrations, go to the Kibana home page, and click **Add Integrations**. You can use the query bar to search for integrations you may want to use. When you find an integration for your data source, the UI walks you through adding and configuring it.

## Extend Integrations with Logstash

Logstash can run the ingest pipeline component of your Elastic integration when you use the Logstash `filter-elastic_integration` plugin in your Logstash pipeline.
Adding the `filter-elastic_integration` plugin as the *first* filter plugin keeps the pipeline’s behavior as close as possible to the behavior you’d expect if the bytes were processed by the integration in Elasticsearch. The more you modify an event before calling the `elastic_integration` filter, the higher the risk that the modifications will have meaningful effect in how the event is transformed.
<admonition title="How to">
  Create a Logstash pipeline that uses the [elastic_agent input](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elastic_agent) plugin, and the [elastic_integration filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) plugin as the *first* filter in your Logstash pipeline. You can add more filters for additional processing, but they must come after the `logstash-filter-elastic_integration` plugin in your configuration. Add one or more output plugins to complete your pipeline.
</admonition>

**Sample pipeline configuration**
```ruby
input {
  elastic_agent {
    port => 5044
  }
}

filter {
  elastic_integration{ 
    cloud_id => "<cloud id>"
    cloud_auth => "<your_cloud-auth"
  }

  translate { 
    source => "[http][host]"
    target => "[@metadata][tenant]"
    dictionary_path => "/etc/conf.d/logstash/tenants.yml"
  }
}

output { 
  if [@metadata][tenant] == "tenant01" {
    elasticsearch {
      cloud_id => "<cloud id>"
      api_key => "<api key>"
    }
  } else if [@metadata][tenant] == "tenant02" {
    elasticsearch {
      cloud_id => "<cloud id>"
      api_key => "<api key>"
    }
  }
}
```


### Using `filter-elastic_integration` with `output-elasticsearch`

Elastic Integrations are designed to work with [data streams](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-data-streams) and [ECS-compatible](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#_compatibility_with_the_elastic_common_schema_ecs) output. Be sure that these features are enabled in the [`output-elasticsearch`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) plugin.
- Set [`data-stream`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-data_stream) to `true`. (Check out [Data streams](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-data-streams) for additional data streams settings.)
- Set [`ecs_compatibility`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-ecs_compatibility) to `v1` or `v8`.

Check out the [`output-elasticsearch` plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) docs for additional settings.