﻿---
title: Upgrading Logstash
description: Upgrade Logstash to 8.18 for an easier upgrade to 9.0.Check out the breaking changes docs.Read the Release Notes.If you’re upgrading other products in...
url: https://www.elastic.co/docs/reference/logstash/upgrading-logstash
products:
  - Logstash
---

# Upgrading Logstash
<admonition title="Upgrade to Logstash 8.18 before upgrading to 9.0">
  Upgrading to Logstash 8.18 gives you a head-start on new 9.0 features.
  This step helps reduce risk and makes roll backs easier if you hit a snag.
</admonition>


## Before you upgrade Logstash

- Upgrade Logstash to 8.18 for an easier upgrade to 9.0.
- Check out the [breaking changes](https://www.elastic.co/docs/release-notes/logstash/breaking-changes) docs.
- Read the [*Release Notes*](https://www.elastic.co/docs/release-notes/logstash).
- If you’re upgrading other products in the stack, check out the [Elastic upgrade documentation](https://www.elastic.co/docs/deploy-manage/upgrade).


## Upgrade tips and considerations

- Test upgrades in a development environment before upgrading your production cluster.
- If you use monitoring, re-use the data directory when you upgrade Logstash. Otherwise, the Logstash node is assigned a new persistent UUID and becomes a new node in the monitoring data.
- If you use the [elastic_integration filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) plugin in Logstash pipelines:
  - Logstash and Elasticsearch must be on the same version.
- The recommended order for upgrading Elastic Stack is Elasticsearch-Logstash-Kibana to ensure the best experience with Elastic Agent-managed pipelines.
  Note that this is different from the typical Elastic Stack upgrade order.
  See [when `elastic_integration` is in Logstash pipeline](#upgrading-when-elastic_integration-in-pipeline) section for details.


## Ways to upgrade

- [Upgrading using package managers](https://www.elastic.co/docs/reference/logstash/upgrading-using-package-managers)
- [Upgrading using a direct download](https://www.elastic.co/docs/reference/logstash/upgrading-using-direct-download)


## When to upgrade

Fresh installations should start with the same version across the Elastic Stack.
Elasticsearch 9.0 does not require Logstash 9.0.
An Elasticsearch 9.0 cluster can receive data from earlier versions of Logstash through the default HTTP communication layer.
This provides some flexibility to decide when to upgrade Logstash relative to an Elasticsearch upgrade.
It may or may not be convenient for you to upgrade them together, and it is not required to be done at the same time as long as Elasticsearch is upgraded first. However, there are special plugin cases for example, if your pipeline includes [elastic_integration filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) plugin. See [when `elastic_integration` is in Logstash pipeline](#upgrading-when-elastic_integration-in-pipeline) section for details.
You should upgrade in a timely manner to get the performance improvements that come with Logstash 9.0, but do so in the way that makes the most sense for your environment.

## When not to upgrade

If any Logstash plugin that you require is not compatible with Logstash 9.0, then you should wait until it is ready before upgrading.
Although we make great efforts to ensure compatibility, Logstash 9.0 is not completely backwards compatible. As noted in the Elastic Stack upgrade guide, you should not upgrade Logstash 9.0 before you upgrade Elasticsearch 9.0. This is both practical and because some Logstash 9.0 plugins may attempt to use features of Elasticsearch 9.0 that did not exist in earlier versions.
For example, if you attempt to send the 8.x template to a cluster before Elasticsearch 9.0, then  all indexing likely fail. If you use your own custom template with Logstash, then this issue can be ignored.
Another example is when your pipeline utilizes the [`elastic_integration` filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) plugin. In such cases, the plugin may encounter issues loading and executing deprecated integrations or features that have been removed in newer versions. This can lead to disruptions in your pipeline’s functionality, especially if your workflow relies on these outdated components. For a comprehensive understanding of how to handle such scenarios and ensure compatibility, refer to the [when `elastic_integration` is in Logstash pipeline](#upgrading-when-elastic_integration-in-pipeline) section in this documentation.

## When `elastic_integration` is in Logstash pipeline

[elastic_integration filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) plugin requires a special attention due to its dependencies on various components of the stack such as Elasticsearch, Kibana and Logstash. Any updates, deprecations, or changes in the stack products can directly impact the functionality of the plugin.
**When upgrading Elasticsearch**
This plugin is compiled with a specific version of Elasticsearch and embeds Elasticsearch Ingest Node components that match the `major.minor` stack version. Therefore, we recommend using a plugin version that aligns with the `major.minor` version of your stack.
If the versions do not match, the plugin may encounter issues such as failing to load or execute pipelines. For example, if your Elasticsearch version is newer than the plugin, the plugin may not support new features introduced in the updated Elasticsearch version. Conversely, if your Elasticsearch version is older, the plugin may rely on features that have been deprecated or removed in your Elasticsearch version.
**When upgrading Kibana**
When you upgrade Kibana, Kibana downloads the latest version of the integrations through [Elastic Package Registry](https://www.elastic.co/docs/reference/fleet/#package-registry-intro). As part of the upgrade process, you will also have the opportunity to review and upgrade your currently installed integrations to their latest versions. However, we strongly recommend upgrading the [elastic_integration filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) plugin before upgrading Kibana and Elasticsearch. This is because [elastic_integration filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) plugin pulls and processes the ingest pipelines associated with the installed integrations. These pipelines are then executed using the Elasticsearch Ingest Node components that the plugin was compiled with. If Elasticsearch or Elasticsearch is upgraded first, there is a risk of incompatibility between the plugin’s ingest componenets and the newer versions of Elasticsearch's Ingest Node features or Kibana's integration definitions.
**When upgrading Logstash**
This plugin is by default embedded in Logstash core. When you upgrade Logstash, new version of the plugin is installed. The plugin is backward compatible accross Logstash 8.x versions. However, if you are considering to upgrade Logstash only (not the plugin), there are exceptions cases, such as JDK compatibility which require matching certain Logstash versions. We recommend visiting [elastic_integration plugin requirements](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration#plugins-filters-elastic_integration-requirements) guide considering the Logstash version you are upgrading to.