﻿---
title: Collect Logstash monitoring data for dashboards (Serverless)
description: Logstash monitoring is available on Elastic Cloud Serverless through the Logstash Integration in Elastic Observability. Elastic Agent collects monitoring...
url: https://www.elastic.co/docs/reference/logstash/serverless-monitoring-with-elastic-agent
products:
  - Logstash
---

# Collect Logstash monitoring data for dashboards (Serverless)
Logstash monitoring is available on Elastic Cloud Serverless through the [Logstash Integration](https://github.com/elastic/integrations/blob/main/packages/logstash/_dev/build/docs/README.md) in [Elastic Observability](https://www.elastic.co/docs/solutions/observability). Elastic Agent collects monitoring data from your Logstash instance, sends it directly to Elastic Cloud Serverless, and shows the data in Logstash dashboards.
You’ll need to have an [Elastic Observability](https://www.elastic.co/docs/solutions/observability) project. We’ll provide steps to help you create one.
**Prerequisite**
<dropdown title="Disable default collection of Logstash monitoring metrics">
  Set `monitoring.enabled` to `false` in logstash.yml to disable default collection:
  ```yaml
  monitoring.enabled: false
  ```
</dropdown>


## Add and configure the Logstash integration

**Add the Logstash integration**
1. Log in to your [cloud.elastic.co](https://cloud.elastic.co/) account and create an Observability serverless project.
2. Select **Get Started** from the main menu.
3. Select **Start exploring** (near the bottom of the page).
4. On the **Integrations** page, search for **Logstash** and select it to see details.
5. Click **Add Logstash**.
6. Follow the instructions to install Elastic Agent and add the Logstash integration.

For more info, check out the [Elastic Observability](https://www.elastic.co/docs/solutions/observability) docs.
**Configure the integration to collect logs**
- Make sure that **Logs** is ON if you want to collect logs from your Logstash instance. Check the settings to be sure that they are configured correctly.
- Modify the log paths to match your Logstash environment.

**Configure the integration to collect metrics**
<tip>
  For the best experience with the Logstash dashboards, we recommend collecting all of the metrics. Turning off metrics will result in incomplete or missing visualizations.
</tip>

- Make sure that **Metrics (Elastic Agent)** is turned on (default), and **Metrics (Stack Monitoring)** is turned off.
- Set the Logstash URL to point to your Logstash instance. By default, the integration collects Logstash monitoring metrics from `https://localhost:9600`. If that host and port number are not correct, update the `Logstash URL` setting. If you configured Logstash to use encrypted communications and/or a username and password, you must access it using HTTPS. Expand the **Advanced Settings** options, and fill in the appropriate values for your Logstash instance.


## View assets

1. Go to **Project settings → Integrations** to see your **Installed integrations**.
2. Select the Logstash integration, and then select **Assets** to access dashboards for the Logstash integration.


## Monitor Logstash logs and metrics

From the list of assets, open the **[Metrics Logstash] Logstash overview** dashboard to view overall performance. Then follow the navigation panel to further drill down into Logstash performance.
![The Logstash Overview dashboard in Kibana with various metrics from your monitored Logstash](https://www.elastic.co/docs/reference/logstash/images/integration-dashboard-overview.png)
You can hover over any visualization to adjust its settings, or click the **Edit** button to make changes to the dashboard. To learn more, refer to [Dashboard and visualizations](https://www.elastic.co/docs/explore-analyze/dashboards).