﻿---
title: Udp output plugin
description: Plugin version: v3.2.0 (Other versions), Released on: 2021-07-14, Changelog. For questions about the plugin, open a topic in the Discuss forums. For bugs...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-udp
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Udp output plugin
- Plugin version: v3.2.0 ([Other versions](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-udp-index))
- Released on: 2021-07-14
- [Changelog](https://github.com/logstash-plugins/logstash-output-udp/blob/v3.2.0/CHANGELOG.md)


## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-udp). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Send events over UDP
Keep in mind that UDP does not provide delivery or duplicate protection guarantees. Even when this plugin succeeds at writing to the UDP socket, there is no guarantee that the recipient will receive exactly one copy of the event.
When this plugin fails to write to the UDP socket, by default the event will be dropped and the error message will be logged. The [`retry_count`](#plugins-outputs-udp-retry_count) option in conjunction with the [`retry_backoff_ms`](#plugins-outputs-udp-retry_backoff_ms) option can be used to retry a failed write for a number of times before dropping the event.

## Udp Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#plugins-outputs-udp-common-options) described later.

| Setting                                                     | Input type                                                    | Required |
|-------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`host`](#plugins-outputs-udp-host)                         | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`port`](#plugins-outputs-udp-port)                         | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`retry_count`](#plugins-outputs-udp-retry_count)           | [number](/docs/reference/logstash/plugins/value-types#number) | No       |
| [`retry_backoff_ms`](#plugins-outputs-udp-retry_backoff_ms) | [number](/docs/reference/logstash/plugins/value-types#number) | No       |

Also see [Common options](#plugins-outputs-udp-common-options) for a list of options supported by all output plugins.

### `host`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The address to send messages to

### `port`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The port to send messages on. This can be dynamic using the `%{[target][port]}` syntax.

### `retry_count`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0`

The number of times to retry a failed UPD socket write

### `retry_backoff_ms`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10`

The amount of time to wait in milliseconds before attempting to retry a failed UPD socket write

## Common options

These configuration options are supported by all output plugins:

| Setting                                               | Input type                                                      | Required |
|-------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#plugins-outputs-udp-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#plugins-outputs-udp-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#plugins-outputs-udp-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"json"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 udp outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  udp {
    id => "my_plugin_id"
  }
}
```