﻿---
title: Sink output plugin
description: Logstash Core Plugin. The sink output plugin cannot be installed or uninstalled independently of Logstash. For questions about the plugin, open a topic...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-sink
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Sink output plugin
**Logstash Core Plugin.** The sink output plugin cannot be installed or uninstalled independently of Logstash.

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash).

## Description

An event sink that discards any events received. Generally useful for testing the performance of inputs and filters.

## Sink Output Configuration Options

There are no special configuration options for this plugin, but it does support the [Common options](#plugins-outputs-sink-common-options).

## Common options

These configuration options are supported by all output plugins:

| Setting                                                | Input type                                                                                     | Required |
|--------------------------------------------------------|------------------------------------------------------------------------------------------------|----------|
| [`codec`](#plugins-outputs-sink-codec)                 | [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)     | No       |
| [`enable_metric`](#plugins-outputs-sink-enable_metric) | [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean) | No       |
| [`id`](#plugins-outputs-sink-id)                       | [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)   | No       |


### `codec`

- Value type is [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 sink outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```json
output {
  sink {
    id => "my_plugin_id"
  }
}
```

<note>
  Variable substitution in the `id` field only supports environment variables and does not support the use of values from the secret store.
</note>