﻿---
title: Metriccatcher output plugin
description: Plugin version: v3.0.4 (Other versions), Released on: 2018-04-06, Changelog. For questions about the plugin, open a topic in the Discuss forums. For bugs...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-metriccatcher
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Metriccatcher output plugin
- Plugin version: v3.0.4 ([Other versions](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-metriccatcher-index))
- Released on: 2018-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-output-metriccatcher/blob/v3.0.4/CHANGELOG.md)


## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-metriccatcher). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output ships metrics to MetricCatcher, allowing you to utilize Coda Hale’s Metrics.
More info on MetricCatcher: 
At Clearspring, we use it to count the response codes from Apache logs:
```
    metriccatcher {
        host => "localhost"
        port => "1420"
        type => "apache-access"
        fields => [ "response" ]
        meter => {
            "%{host}.apache.response.%{response}" => "1"
            }
    }
```


## Metriccatcher Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#plugins-outputs-metriccatcher-common-options) described later.

| Setting                                             | Input type                                                    | Required |
|-----------------------------------------------------|---------------------------------------------------------------|----------|
| [`biased`](#plugins-outputs-metriccatcher-biased)   | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`counter`](#plugins-outputs-metriccatcher-counter) | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`gauge`](#plugins-outputs-metriccatcher-gauge)     | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`host`](#plugins-outputs-metriccatcher-host)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`meter`](#plugins-outputs-metriccatcher-meter)     | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`port`](#plugins-outputs-metriccatcher-port)       | [number](/docs/reference/logstash/plugins/value-types#number) | No       |
| [`timer`](#plugins-outputs-metriccatcher-timer)     | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |
| [`uniform`](#plugins-outputs-metriccatcher-uniform) | [hash](/docs/reference/logstash/plugins/value-types#hash)     | No       |

Also see [Common options](#plugins-outputs-metriccatcher-common-options) for a list of options supported by all output plugins.

### `biased`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

The metrics to send. This supports dynamic strings like `%{host}` for metric names and also for values. This is a hash field with key of the metric name, value of the metric value.
The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

### `counter`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

The metrics to send. This supports dynamic strings like `%{host}` for metric names and also for values. This is a hash field with key of the metric name, value of the metric value. Example:
```
  counter => { "%{host}.apache.hits.%{response} => "1" }
```

The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

### `gauge`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

The metrics to send. This supports dynamic strings like `%{host}` for metric names and also for values. This is a hash field with key of the metric name, value of the metric value.
The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"localhost"`

The address of the MetricCatcher

### `meter`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

The metrics to send. This supports dynamic strings like `%{host}` for metric names and also for values. This is a hash field with key of the metric name, value of the metric value.
The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1420`

The port to connect on your MetricCatcher

### `timer`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

The metrics to send. This supports dynamic strings like %{host} for metric names and also for values. This is a hash field with key of the metric name, value of the metric value. Example:
```
  timer => { "%{host}.apache.response_time => "%{response_time}" }
```

The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

### `uniform`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

The metrics to send. This supports dynamic strings like `%{host}` for metric names and also for values. This is a hash field with key of the metric name, value of the metric value.
The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

## Common options

These configuration options are supported by all output plugins:

| Setting                                                         | Input type                                                      | Required |
|-----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#plugins-outputs-metriccatcher-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#plugins-outputs-metriccatcher-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#plugins-outputs-metriccatcher-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 metriccatcher outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  metriccatcher {
    id => "my_plugin_id"
  }
}
```