﻿---
title: Java_stdout output plugin
description: Logstash Core Plugin. The java_stdout output plugin cannot be installed or uninstalled independently of Logstash. For questions about the plugin, open...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-java_stdout
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Java_stdout output plugin
**Logstash Core Plugin.** The java_stdout output plugin cannot be installed or uninstalled independently of Logstash.

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash).

## Description

Prints events to the STDOUT of the shell running Logstash. This output is convenient for debugging plugin configurations by providing instant access to event data after it has passed through the inputs and filters.
For example, the following output configuration in conjunction with the Logstash `-e` command-line flag, will allow you to see the results of your event pipeline for quick iteration.
```ruby
    output {
      java_stdout {}
    }
```

Useful codecs include:
`java_line`: outputs event data in JSON format followed by an end-of-line character. This is the default codec for java_stdout.
```ruby
    output {
      stdout { }
    }
```


## Java_stdout Output Configuration Options

There are no special configuration options for this plugin, but it does support the [Common options](#plugins-outputs-java_stdout-common-options).

## Common options

These configuration options are supported by all output plugins:

| Setting                                                       | Input type                                                                                     | Required |
|---------------------------------------------------------------|------------------------------------------------------------------------------------------------|----------|
| [`codec`](#plugins-outputs-java_stdout-codec)                 | [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)     | No       |
| [`enable_metric`](#plugins-outputs-java_stdout-enable_metric) | [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean) | No       |
| [`id`](#plugins-outputs-java_stdout-id)                       | [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)   | No       |


### `codec`

- Value type is [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)
- Default value is `"java_line"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 java_stdout outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```json
output {
  java_stdout {
    id => "my_plugin_id"
  }
}
```

<note>
  Variable substitution in the `id` field only supports environment variables and does not support the use of values from the secret store.
</note>