﻿---
title: Circonus output plugin
description: Plugin version: v3.0.7 (Other versions), Released on: 2023-05-30, Changelog. For questions about the plugin, open a topic in the Discuss forums. For bugs...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-circonus
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Circonus output plugin
- Plugin version: v3.0.7 ([Other versions](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-circonus-index))
- Released on: 2023-05-30
- [Changelog](https://github.com/logstash-plugins/logstash-output-circonus/blob/v3.0.7/CHANGELOG.md)


## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-circonus). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output sends annotations to Circonus based on Logstash events.

## Circonus Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#plugins-outputs-circonus-common-options) described later.

| Setting                                              | Input type                                                        | Required |
|------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`annotation`](#plugins-outputs-circonus-annotation) | [hash](/docs/reference/logstash/plugins/value-types#hash)         | Yes      |
| [`api_token`](#plugins-outputs-circonus-api_token)   | [password](/docs/reference/logstash/plugins/value-types#password) | Yes      |
| [`app_name`](#plugins-outputs-circonus-app_name)     | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |

Also see [Common options](#plugins-outputs-circonus-common-options) for a list of options supported by all output plugins.

### `annotation`

- This is a required setting.
- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Annotations Registers an annotation with Circonus The only required field is `title` and `description`. `start` and `stop` will be set to the event timestamp. You can add any other optional annotation values as well. All values will be passed through `event.sprintf`
Example:
```
  ["title":"Logstash event", "description":"Logstash event for %{host}"]
```

or
```
  ["title":"Logstash event", "description":"Logstash event for %{host}", "parent_id", "1"]
```


### `api_token`

- This is a required setting.
- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Your Circonus API Token

### `app_name`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Your Circonus App name This will be passed through `event.sprintf` so variables are allowed here:
Example: `app_name => "%{myappname}"`

## Common options

These configuration options are supported by all output plugins:

| Setting                                                    | Input type                                                      | Required |
|------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#plugins-outputs-circonus-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#plugins-outputs-circonus-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#plugins-outputs-circonus-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 circonus outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  circonus {
    id => "my_plugin_id"
  }
}
```