﻿---
title: Java_stdin input plugin
description: Logstash Core Plugin. The java_stdin input plugin cannot be installed or uninstalled independently of Logstash. For questions about the plugin, open a...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-java_stdin
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Java_stdin input plugin
**Logstash Core Plugin.** The java_stdin input plugin cannot be installed or uninstalled independently of Logstash.

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash).

## Description

Read events from standard input.
By default, each event is assumed to be terminated by end-of-line. If you want events delimited in a different method, you’ll need to use a codec with support for that encoding.

## Java_stdin Input Configuration Options

There are no special configuration options for this plugin, but it does support the [Common options](#plugins-inputs-java_stdin-common-options).

## Common options

These configuration options are supported by all input plugins:

| Setting                                                     | Input type                                                                                     | Required |
|-------------------------------------------------------------|------------------------------------------------------------------------------------------------|----------|
| [`add_field`](#plugins-inputs-java_stdin-add_field)         | [hash](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#hash)       | No       |
| [`codec`](#plugins-inputs-java_stdin-codec)                 | [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)     | No       |
| [`enable_metric`](#plugins-inputs-java_stdin-enable_metric) | [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean) | No       |
| [`id`](#plugins-inputs-java_stdin-id)                       | [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)   | No       |
| [`tags`](#plugins-inputs-java_stdin-tags)                   | [array](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#array)     | No       |
| [`type`](#plugins-inputs-java_stdin-type)                   | [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)   | No       |


### `add_field`

- Value type is [hash](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)
- Default value is `"java_line"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 java_stdin inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```json
input {
  java_stdin {
    id => "my_plugin_id"
  }
}
```

<note>
  Variable substitution in the `id` field only supports environment variables and does not support the use of values from the secret store.
</note>


### `tags`

- Value type is [array](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.