﻿---
title: Java_generator input plugin
description: Logstash Core Plugin. The java_generator input plugin cannot be installed or uninstalled independently of Logstash. For questions about the plugin, open...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-java_generator
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Java_generator input plugin
**Logstash Core Plugin.** The java_generator input plugin cannot be installed or uninstalled independently of Logstash.

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash).

## Description

Generate synthetic log events.
This plugin generates a stream of synthetic events that can be used to test the correctness or performance of a Logstash pipeline.

## Java_generator Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#plugins-inputs-java_generator-common-options) described later.

| Setting                                             | Input type                                                    | Required |
|-----------------------------------------------------|---------------------------------------------------------------|----------|
| [`count`](#plugins-inputs-java_generator-count)     | [number](/docs/reference/logstash/plugins/value-types#number) | No       |
| [`eps`](#plugins-inputs-java_generator-eps)         | [number](/docs/reference/logstash/plugins/value-types#number) | No       |
| [`lines`](#plugins-inputs-java_generator-lines)     | [array](/docs/reference/logstash/plugins/value-types#array)   | No       |
| [`message`](#plugins-inputs-java_generator-message) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`threads`](#plugins-inputs-java_generator-threads) | [number](/docs/reference/logstash/plugins/value-types#number) | No       |

Also see [Common options](#plugins-inputs-java_generator-common-options) for a list of options supported by all input plugins.


### `count`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0`

Sets the number of events that should be generated.
The default, `0`, means generate an unlimited number of events.

### `eps`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0`

Sets the rate at which events should be generated. Fractional values may be specified. For example, a rate of `0.25` means that one event will be generated every four seconds.
The default, `0`, means generate events as fast as possible.

### `lines`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

The lines to emit, in order. This option overrides the *message* setting if it has also been specified.
Example:
```ruby
    input {
      java_generator {
        lines => [
          "line 1",
          "line 2",
          "line 3"
        ]
        # Emit all lines 2 times.
        count => 2
      }
    }
```

The above will emit a series of three events `line 1` then `line 2` then `line 3` two times for a total of 6 events.

### `message`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"Hello world!"`

The message string to use in the event.

### `threads`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`

Increasing the number of generator threads up to about the number of CPU cores generally increases overall event throughput. The `count`, `eps`, and `lines` settings all apply on a per-thread basis. In other words, each thread will emit the number of events specified in the `count` setting for a total of `threads * count` events. Each thread will emit events at the `eps` rate for a total rate of `threads * eps`, and each thread will emit each line specified in the `lines` option.

## Common options

These configuration options are supported by all input plugins:

| Setting                                                         | Input type                                                                                     | Required |
|-----------------------------------------------------------------|------------------------------------------------------------------------------------------------|----------|
| [`add_field`](#plugins-inputs-java_generator-add_field)         | [hash](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#hash)       | No       |
| [`codec`](#plugins-inputs-java_generator-codec)                 | [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)     | No       |
| [`enable_metric`](#plugins-inputs-java_generator-enable_metric) | [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean) | No       |
| [`id`](#plugins-inputs-java_generator-id)                       | [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)   | No       |
| [`tags`](#plugins-inputs-java_generator-tags)                   | [array](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#array)     | No       |
| [`type`](#plugins-inputs-java_generator-type)                   | [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)   | No       |


### `add_field`

- Value type is [hash](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 java_generator inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```json
input {
  java_generator {
    id => "my_plugin_id"
  }
}
```

<note>
  Variable substitution in the `id` field only supports environment variables and does not support the use of values from the secret store.
</note>


### `tags`

- Value type is [array](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](https://www.elastic.co/docs/reference/logstash/configuration-file-structure#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.