﻿---
title: Fluent codec plugin
description: Plugin version: v3.4.3 (Other versions), Released on: 2024-06-25, Changelog. For questions about the plugin, open a topic in the Discuss forums. For bugs...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-fluent
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Fluent codec plugin
- Plugin version: v3.4.3 ([Other versions](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-fluent-index))
- Released on: 2024-06-25
- [Changelog](https://github.com/logstash-plugins/logstash-codec-fluent/blob/v3.4.3/CHANGELOG.md)


## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-fluent). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This codec handles fluentd’s msgpack schema.
For example, you can receive logs from `fluent-logger-ruby` with:
```
    input {
      tcp {
        codec => fluent
        port => 4000
      }
    }
```

And from your ruby code in your own application:
```
    logger = Fluent::Logger::FluentLogger.new(nil, :host => "example.log", :port => 4000)
    logger.post("some_tag", { "your" => "data", "here" => "yay!" })
```

Fluent uses second-precision for events, so you will not see sub-second precision on events processed by this codec.

## Fluent Codec configuration options


| Setting                                                               | Input type                                                      | Required |
|-----------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`nanosecond_precision`](#plugins-codecs-fluent-nanosecond_precision) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`target`](#plugins-codecs-fluent-target)                             | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `nanosecond_precision`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Enables sub-second level precision while encoding events.

### `target`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Define the target field for placing the decoded values. If this setting is not set, data will be stored at the root (top level) of the event.
For example, if you want data to be put under the `logs` field:
```
    input {
      tcp {
        codec => fluent {
          target => "[logs]"
        }
        port => 4000
      }
    }
```