﻿---
title: Es_bulk codec plugin
description: Plugin version: v3.1.0 (Other versions), Released on: 2021-08-19, Changelog. For questions about the plugin, open a topic in the Discuss forums. For bugs...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-es_bulk
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Es_bulk codec plugin
- Plugin version: v3.1.0 ([Other versions](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-es_bulk-index))
- Released on: 2021-08-19
- [Changelog](https://github.com/logstash-plugins/logstash-codec-es_bulk/blob/v3.1.0/CHANGELOG.md)


## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-es_bulk). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This codec will decode the [Elasticsearch bulk format](https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-bulk.html) into individual events, plus metadata into the `@metadata` field.
Encoding is not supported at this time as the Elasticsearch output submits Logstash events in bulk format.

## Codec settings in the `logstash-input-http` plugin

The [input-http](https://www.elastic.co/guide/en/logstash/current/plugins-inputs-http.html) plugin has two configuration options for codecs: `codec` and `additional_codecs`.
Values in `additional_codecs` are prioritized over those specified in the `codec` option. That is, the default `codec` is applied only if no codec for the request’s content-type is found in the `additional_codecs` setting.

## Event Metadata and the Elastic Common Schema (ECS)

When ECS compatibility is disabled, the metadata is stored in the `[@metadata]` field. When ECS is enabled, the metadata is stored in the `[@metadata][codec][es_bulk]` field.

## ES Bulk Codec Configuration Options


| Setting                                                          | Input type                                                    | Required |
|------------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`ecs_compatibility`](#plugins-codecs-es_bulk-ecs_compatibility) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`target`](#plugins-codecs-es_bulk-target)                       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |


### `ecs_compatibility`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - `disabled`: unstructured metadata added at @metadata
- `v1`: uses `[@metadata][codec][es_bulk]` fields

Controls this plugin’s compatibility with the [Elastic Common Schema (ECS)](https://www.elastic.co/guide/en/ecs/current).

### `target`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Define the target field for placing the values. If this setting is not set, the data will be stored at the root (top level) of the event.
For example, if you want data to be put under the `document` field:
```
input {
  kafka {
    codec => es_bulk {
        target => "[document]"
    }
  }
}
```