﻿---
title: Edn codec plugin
description: Plugin version: v3.1.0 (Other versions), Released on: 2021-08-04, Changelog. For questions about the plugin, open a topic in the Discuss forums. For bugs...
url: https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-edn
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Edn codec plugin
- Plugin version: v3.1.0 ([Other versions](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-edn-index))
- Released on: 2021-08-04
- [Changelog](https://github.com/logstash-plugins/logstash-codec-edn/blob/v3.1.0/CHANGELOG.md)


## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-edn). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Reads and produces EDN format data.

## Edn Codec configuration options


| Setting                                | Input type                                                    | Required |
|----------------------------------------|---------------------------------------------------------------|----------|
| [`target`](#plugins-codecs-edn-target) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |


### `target`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.
- The option is only relevant while decoding.

Define the target field for placing the decoded fields. If this setting is not set, data will be stored at the root (top level) of the event.
For example, if you want data to be put under the `document` field:
```
    input {
      tcp {
        port => 4242
        codec => edn {
          target => "[document]"
        }
      }
    }
```