﻿---
title: Integration plugins
description: Integration plugins combine related plugins--inputs, outputs, and sometimes filters and codecs--into one package. 
url: https://www.elastic.co/docs/reference/logstash/plugins/plugin-integrations
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Integration plugins
Integration plugins combine related plugins--inputs, outputs, and sometimes
filters and codecs--into one package.

| Plugin                                                                                           | Description                                                                                                            | Github repository                                                                                  |
|--------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------|
| [aws](https://www.elastic.co/docs/reference/logstash/plugins/plugins-integrations-aws)           | Plugins for use with Amazon Web Services (AWS).                                                                        | [logstash-integration-aws](https://github.com/logstash-plugins/logstash-integration-aws)           |
| [jdbc](https://www.elastic.co/docs/reference/logstash/plugins/plugins-integrations-jdbc)         | Plugins for use with databases that provide JDBC drivers.                                                              | [logstash-integration-jdbc](https://github.com/logstash-plugins/logstash-integration-jdbc)         |
| [kafka](https://www.elastic.co/docs/reference/logstash/plugins/plugins-integrations-kafka)       | Plugins for use with the Kafka distributed streaming platform.                                                         | [logstash-integration-kafka](https://github.com/logstash-plugins/logstash-integration-kafka)       |
| [logstash](https://www.elastic.co/docs/reference/logstash/plugins/plugins-integrations-logstash) | Plugins to enable Logstash-to-Logstash communication.                                                                  | [logstash-integration-logstash](https://github.com/logstash-plugins/logstash-integration-logstash) |
| [rabbitmq](https://www.elastic.co/docs/reference/logstash/plugins/plugins-integrations-rabbitmq) | Plugins for processing events to or from a RabbitMQ broker.                                                            | [logstash-integration-rabbitmq](https://github.com/logstash-plugins/logstash-integration-rabbitmq) |
| [snmp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-integrations-snmp)         | Plugins for polling devices using Simple Network Management Protocol (SNMP) or creating events from SNMPtrap messages. | [logstash-integration-snmp](https://github.com/logstash-plugins/logstash-integration-snmp)         |