﻿---
title: Output plugins for Logstash
description: An output plugin sends event data to a particular destination. Outputs are the final stage in the event pipeline. The following output plugins are available...
url: https://www.elastic.co/docs/reference/logstash/plugins/output-plugins
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Output plugins for Logstash
An output plugin sends event data to a particular destination. Outputs are the final stage in the event pipeline.
The following output plugins are available below. For a list of Elastic supported plugins, please consult the [Support Matrix](https://www.elastic.co/support/matrix#show_logstash_plugins).

| Plugin                                                                                                                      | Description                                                                                     | Github repository                                                                                                                   |
|-----------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------|
| [boundary](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-boundary)                                 | Sends annotations to Boundary based on Logstash events                                          | [logstash-output-boundary](https://github.com/logstash-plugins/logstash-output-boundary)                                            |
| [circonus](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-circonus)                                 | Sends annotations to Circonus based on Logstash events                                          | [logstash-output-circonus](https://github.com/logstash-plugins/logstash-output-circonus)                                            |
| [cloudwatch](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-cloudwatch)                             | Aggregates and sends metric data to AWS CloudWatch                                              | [logstash-output-cloudwatch](https://github.com/logstash-plugins/logstash-output-cloudwatch)                                        |
| [csv](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-csv)                                           | Writes events to disk in a delimited format                                                     | [logstash-output-csv](https://github.com/logstash-plugins/logstash-output-csv)                                                      |
| [datadog](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-datadog)                                   | Sends events to DataDogHQ based on Logstash events                                              | [logstash-output-datadog](https://github.com/logstash-plugins/logstash-output-datadog)                                              |
| [datadog_metrics](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-datadog_metrics)                   | Sends metrics to DataDogHQ based on Logstash events                                             | [logstash-output-datadog_metrics](https://github.com/logstash-plugins/logstash-output-datadog_metrics)                              |
| [dynatrace](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-dynatrace)                               | Sends events to Dynatrace based on Logstash events                                              | [logstash-output-dynatrace](https://github.com/dynatrace-oss/logstash-output-dynatrace)                                             |
| [elastic_workplace_search](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elastic_workplace_search) | Sends events to the https://www.elastic.co/enterprise-search[Elastic Workplace Search] solution | [logstash-integration-elastic_enterprise_search](https://github.com/logstash-plugins/logstash-output-elastic_app_search)            |
| [elasticsearch](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch)                       | Stores logs in Elasticsearch                                                                    | [logstash-output-elasticsearch](https://github.com/logstash-plugins/logstash-output-elasticsearch)                                  |
| [email](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-email)                                       | Sends email to a specified address when output is received                                      | [logstash-output-email](https://github.com/logstash-plugins/logstash-output-email)                                                  |
| [exec](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-exec)                                         | Runs a command for a matching event                                                             | [logstash-output-exec](https://github.com/logstash-plugins/logstash-output-exec)                                                    |
| [file](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-file)                                         | Writes events to files on disk                                                                  | [logstash-output-file](https://github.com/logstash-plugins/logstash-output-file)                                                    |
| [ganglia](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-ganglia)                                   | Writes metrics to Ganglia's `gmond`                                                             | [logstash-output-ganglia](https://github.com/logstash-plugins/logstash-output-ganglia)                                              |
| [gelf](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-gelf)                                         | Generates GELF formatted output for Graylog2                                                    | [logstash-output-gelf](https://github.com/logstash-plugins/logstash-output-gelf)                                                    |
| [google_bigquery](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-google_bigquery)                   | Writes events to Google BigQuery                                                                | [logstash-output-google_bigquery](https://github.com/logstash-plugins/logstash-output-google_bigquery)                              |
| [google_cloud_storage](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-google_cloud_storage)         | Uploads log events to Google Cloud Storage                                                      | [logstash-output-google_cloud_storage](https://github.com/logstash-plugins/logstash-output-google_cloud_storage)                    |
| [google_pubsub](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-google_pubsub)                       | Uploads log events to Google Cloud Pubsub                                                       | [logstash-output-google_pubsub](https://github.com/logstash-plugins/logstash-output-google_pubsub)                                  |
| [graphite](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-graphite)                                 | Writes metrics to Graphite                                                                      | [logstash-output-graphite](https://github.com/logstash-plugins/logstash-output-graphite)                                            |
| [graphtastic](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-graphtastic)                           | Sends metric data on Windows                                                                    | [logstash-output-graphtastic](https://github.com/logstash-plugins/logstash-output-graphtastic)                                      |
| [http](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-http)                                         | Sends events to a generic HTTP or HTTPS endpoint                                                | [logstash-output-http](https://github.com/logstash-plugins/logstash-output-http)                                                    |
| [influxdb](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-influxdb)                                 | Writes metrics to InfluxDB                                                                      | [logstash-output-influxdb](https://github.com/logstash-plugins/logstash-output-influxdb)                                            |
| [irc](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-irc)                                           | Writes events to IRC                                                                            | [logstash-output-irc](https://github.com/logstash-plugins/logstash-output-irc)                                                      |
| [java_stdout](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-java_stdout)                           | Prints events to the STDOUT of the shell                                                        | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/outputs/Stdout.java) |
| [juggernaut](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-juggernaut)                             | Pushes messages to the Juggernaut websockets server                                             | [logstash-output-juggernaut](https://github.com/logstash-plugins/logstash-output-juggernaut)                                        |
| [kafka](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-kafka)                                       | Writes events to a Kafka topic                                                                  | [logstash-integration-kafka](https://github.com/logstash-plugins/logstash-integration-kafka)                                        |
| [librato](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-librato)                                   | Sends metrics, annotations, and alerts to Librato based on Logstash events                      | [logstash-output-librato](https://github.com/logstash-plugins/logstash-output-librato)                                              |
| [loggly](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-loggly)                                     | Ships logs to Loggly                                                                            | [logstash-output-loggly](https://github.com/logstash-plugins/logstash-output-loggly)                                                |
| [logstash](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-logstash)                                 | Ships data to Logstash input on another Logstash instance                                       | [logstash-integration-logstash](https://github.com/logstash-plugins/logstash-integration-logstash)                                  |
| [lumberjack](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-lumberjack)                             | Sends events using the `lumberjack` protocol                                                    | [logstash-output-lumberjack](https://github.com/logstash-plugins/logstash-output-lumberjack)                                        |
| [metriccatcher](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-metriccatcher)                       | Writes metrics to MetricCatcher                                                                 | [logstash-output-metriccatcher](https://github.com/logstash-plugins/logstash-output-metriccatcher)                                  |
| [mongodb](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-mongodb)                                   | Writes events to MongoDB                                                                        | [logstash-output-mongodb](https://github.com/logstash-plugins/logstash-output-mongodb)                                              |
| [nagios](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-nagios)                                     | Sends passive check results to Nagios                                                           | [logstash-output-nagios](https://github.com/logstash-plugins/logstash-output-nagios)                                                |
| [nagios_nsca](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-nagios_nsca)                           | Sends passive check results to Nagios using the NSCA protocol                                   | [logstash-output-nagios_nsca](https://github.com/logstash-plugins/logstash-output-nagios_nsca)                                      |
| [opentsdb](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-opentsdb)                                 | Writes metrics to OpenTSDB                                                                      | [logstash-output-opentsdb](https://github.com/logstash-plugins/logstash-output-opentsdb)                                            |
| [pagerduty](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-pagerduty)                               | Sends notifications based on preconfigured services and escalation policies                     | [logstash-output-pagerduty](https://github.com/logstash-plugins/logstash-output-pagerduty)                                          |
| [pipe](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-pipe)                                         | Pipes events to another program's standard input                                                | [logstash-output-pipe](https://github.com/logstash-plugins/logstash-output-pipe)                                                    |
| [rabbitmq](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-rabbitmq)                                 | Pushes events to a RabbitMQ exchange                                                            | [logstash-integration-rabbitmq](https://github.com/logstash-plugins/logstash-integration-rabbitmq)                                  |
| [redis](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-redis)                                       | Sends events to a Redis queue using the `RPUSH` command                                         | [logstash-output-redis](https://github.com/logstash-plugins/logstash-output-redis)                                                  |
| [redmine](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-redmine)                                   | Creates tickets using the Redmine API                                                           | [logstash-output-redmine](https://github.com/logstash-plugins/logstash-output-redmine)                                              |
| [riak](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-riak)                                         | Writes events to the Riak distributed key/value store                                           | [logstash-output-riak](https://github.com/logstash-plugins/logstash-output-riak)                                                    |
| [riemann](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-riemann)                                   | Sends metrics to Riemann                                                                        | [logstash-output-riemann](https://github.com/logstash-plugins/logstash-output-riemann)                                              |
| [s3](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-s3)                                             | Sends Logstash events to the Amazon Simple Storage Service                                      | [logstash-output-s3](https://github.com/logstash-plugins/logstash-output-s3)                                                        |
| [sink](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-sink)                                         | Discards any events received                                                                    | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/outputs/Sink.java)   |
| [sns](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-sns)                                           | Sends events to Amazon's Simple Notification Service                                            | [logstash-output-sns](https://github.com/logstash-plugins/logstash-output-sns)                                                      |
| [solr_http](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-solr_http)                               | Stores and indexes logs in Solr                                                                 | [logstash-output-solr_http](https://github.com/logstash-plugins/logstash-output-solr_http)                                          |
| [sqs](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-sqs)                                           | Pushes events to an Amazon Web Services Simple Queue Service queue                              | [logstash-output-sqs](https://github.com/logstash-plugins/logstash-output-sqs)                                                      |
| [statsd](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-statsd)                                     | Sends metrics using the `statsd` network daemon                                                 | [logstash-output-statsd](https://github.com/logstash-plugins/logstash-output-statsd)                                                |
| [stdout](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-stdout)                                     | Prints events to the standard output                                                            | [logstash-output-stdout](https://github.com/logstash-plugins/logstash-output-stdout)                                                |
| [stomp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-stomp)                                       | Writes events using the STOMP protocol                                                          | [logstash-output-stomp](https://github.com/logstash-plugins/logstash-output-stomp)                                                  |
| [syslog](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-syslog)                                     | Sends events to a `syslog` server                                                               | [logstash-output-syslog](https://github.com/logstash-plugins/logstash-output-syslog)                                                |
| [tcp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-tcp)                                           | Writes events over a TCP socket                                                                 | [logstash-output-tcp](https://github.com/logstash-plugins/logstash-output-tcp)                                                      |
| [timber](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-timber)                                     | Sends events to the Timber.io logging service                                                   | [logstash-output-timber](https://github.com/logstash-plugins/logstash-output-timber)                                                |
| [udp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-udp)                                           | Sends events over UDP                                                                           | [logstash-output-udp](https://github.com/logstash-plugins/logstash-output-udp)                                                      |
| [webhdfs](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-webhdfs)                                   | Sends Logstash events to HDFS using the `webhdfs` REST API                                      | [logstash-output-webhdfs](https://github.com/logstash-plugins/logstash-output-webhdfs)                                              |
| [websocket](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-websocket)                               | Publishes messages to a websocket                                                               | [logstash-output-websocket](https://github.com/logstash-plugins/logstash-output-websocket)                                          |
| [xmpp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-xmpp)                                         | Posts events over XMPP                                                                          | [logstash-output-xmpp](https://github.com/logstash-plugins/logstash-output-xmpp)                                                    |
| [zabbix](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-zabbix)                                     | Sends events to a Zabbix server                                                                 | [logstash-output-zabbix](https://github.com/logstash-plugins/logstash-output-zabbix)                                                |