﻿---
title: Input plugins
description: An input plugin enables a specific source of events to be read by Logstash. The following input plugins are available below. For a list of Elastic supported...
url: https://www.elastic.co/docs/reference/logstash/plugins/input-plugins
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Input plugins
An input plugin enables a specific source of events to be read by Logstash.
The following input plugins are available below. For a list of Elastic supported plugins, please consult the [Support Matrix](https://www.elastic.co/support/matrix#show_logstash_plugins).

| Plugin                                                                                                                             | Description                                                           | Github repository                                                                                                                     |
|------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------|
| [azure_event_hubs](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-azure_event_hubs)                         | Receives events from Azure Event Hubs                                 | [azure_event_hubs](https://github.com/logstash-plugins/logstash-input-azure_event_hubs)                                               |
| [beats](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-beats)                                               | Receives events from the Elastic Beats framework                      | [logstash-input-beats](https://github.com/logstash-plugins/logstash-input-beats)                                                      |
| [cloudwatch](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-cloudwatch)                                     | Pulls events from the Amazon Web Services CloudWatch API              | [logstash-input-cloudwatch](https://github.com/logstash-plugins/logstash-input-cloudwatch)                                            |
| [couchdb_changes](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-couchdb_changes)                           | Streams events from CouchDB's `_changes` URI                          | [logstash-input-couchdb_changes](https://github.com/logstash-plugins/logstash-input-couchdb_changes)                                  |
| [dead_letter_queue](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-dead_letter_queue)                       | read events from Logstash's dead letter queue                         | [logstash-input-dead_letter_queue](https://github.com/logstash-plugins/logstash-input-dead_letter_queue)                              |
| [elastic_agent](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elastic_agent)                               | Receives events from the Elastic Agent framework                      | [logstash-input-beats](https://github.com/logstash-plugins/logstash-input-beats) (shared)                                             |
| [elastic_serverless_forwarder](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elastic_serverless_forwarder) | Accepts events from Elastic Serverless Forwarder                      | [logstash-input-elastic_serverless_forwarder](https://github.com/logstash-plugins/logstash-input-elastic_serverless_forwarder)        |
| [elasticsearch](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elasticsearch)                               | Reads query results from an Elasticsearch cluster                     | [logstash-input-elasticsearch](https://github.com/logstash-plugins/logstash-input-elasticsearch)                                      |
| [exec](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-exec)                                                 | Captures the output of a shell command as an event                    | [logstash-input-exec](https://github.com/logstash-plugins/logstash-input-exec)                                                        |
| [file](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-file)                                                 | Streams events from files                                             | [logstash-input-file](https://github.com/logstash-plugins/logstash-input-file)                                                        |
| [ganglia](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-ganglia)                                           | Reads Ganglia packets over UDP                                        | [logstash-input-ganglia](https://github.com/logstash-plugins/logstash-input-ganglia)                                                  |
| [gelf](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-gelf)                                                 | Reads GELF-format messages from Graylog2 as events                    | [logstash-input-gelf](https://github.com/logstash-plugins/logstash-input-gelf)                                                        |
| [generator](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-generator)                                       | Generates random log events for test purposes                         | [logstash-input-generator](https://github.com/logstash-plugins/logstash-input-generator)                                              |
| [github](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-github)                                             | Reads events from a GitHub webhook                                    | [logstash-input-github](https://github.com/logstash-plugins/logstash-input-github)                                                    |
| [google_cloud_storage](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-google_cloud_storage)                 | Extract events from files in a Google Cloud Storage bucket            | [logstash-input-google_cloud_storage](https://github.com/logstash-plugins/logstash-input-google_cloud_storage)                        |
| [google_pubsub](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-google_pubsub)                               | Consume events from a Google Cloud PubSub service                     | [logstash-input-google_pubsub](https://github.com/logstash-plugins/logstash-input-google_pubsub)                                      |
| [graphite](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-graphite)                                         | Reads metrics from the `graphite` tool                                | [logstash-input-graphite](https://github.com/logstash-plugins/logstash-input-graphite)                                                |
| [heartbeat](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-heartbeat)                                       | Generates heartbeat events for testing                                | [logstash-input-heartbeat](https://github.com/logstash-plugins/logstash-input-heartbeat)                                              |
| [http](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-http)                                                 | Receives events over HTTP or HTTPS                                    | [logstash-input-http](https://github.com/logstash-plugins/logstash-input-http)                                                        |
| [http_poller](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-http_poller)                                   | Decodes the output of an HTTP API into events                         | [logstash-input-http_poller](https://github.com/logstash-plugins/logstash-input-http_poller)                                          |
| [imap](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-imap)                                                 | Reads mail from an IMAP server                                        | [logstash-input-imap](https://github.com/logstash-plugins/logstash-input-imap)                                                        |
| [irc](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-irc)                                                   | Reads events from an IRC server                                       | [logstash-input-irc](https://github.com/logstash-plugins/logstash-input-irc)                                                          |
| [java_generator](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-java_generator)                             | Generates synthetic log events                                        | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/inputs/Generator.java) |
| [java_stdin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-java_stdin)                                     | Reads events from standard input                                      | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/inputs/Stdin.java)     |
| [jdbc](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-jdbc)                                                 | Creates events from JDBC data                                         | [logstash-integration-jdbc](https://github.com/logstash-plugins/logstash-integration-jdbc)                                            |
| [jms](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-jms)                                                   | Reads events from a Jms Broker                                        | [logstash-input-jms](https://github.com/logstash-plugins/logstash-input-jms)                                                          |
| [jmx](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-jmx)                                                   | Retrieves metrics from remote Java applications over JMX              | [logstash-input-jmx](https://github.com/logstash-plugins/logstash-input-jmx)                                                          |
| [kafka](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-kafka)                                               | Reads events from a Kafka topic                                       | [logstash-integration-kafka](https://github.com/logstash-plugins/logstash-integration-kafka)                                          |
| [kinesis](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-kinesis)                                           | Receives events through an AWS Kinesis stream                         | [logstash-input-kinesis](https://github.com/logstash-plugins/logstash-input-kinesis)                                                  |
| [log4j](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-log4j)                                               | Reads events over a TCP socket from a Log4j `SocketAppender` object   | [logstash-input-log4j](https://github.com/logstash-plugins/logstash-input-log4j)                                                      |
| [logstash](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-logstash)                                         | Reads from Logstash output of another Logstash instance               | [logstash-integration-logstash](https://github.com/logstash-plugins/logstash-integration-logstash)                                    |
| [lumberjack](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-lumberjack)                                     | Receives events using the Lumberjack protocl                          | [logstash-input-lumberjack](https://github.com/logstash-plugins/logstash-input-lumberjack)                                            |
| [meetup](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-meetup)                                             | Captures the output of command line tools as an event                 | [logstash-input-meetup](https://github.com/logstash-plugins/logstash-input-meetup)                                                    |
| [pipe](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-pipe)                                                 | Streams events from a long-running command pipe                       | [logstash-input-pipe](https://github.com/logstash-plugins/logstash-input-pipe)                                                        |
| [puppet_facter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-puppet_facter)                               | Receives facts from a Puppet server                                   | [logstash-input-puppet_facter](https://github.com/logstash-plugins/logstash-input-puppet_facter)                                      |
| [rabbitmq](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-rabbitmq)                                         | Pulls events from a RabbitMQ exchange                                 | [logstash-integration-rabbitmq](https://github.com/logstash-plugins/logstash-integration-rabbitmq)                                    |
| [redis](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-redis)                                               | Reads events from a Redis instance                                    | [logstash-input-redis](https://github.com/logstash-plugins/logstash-input-redis)                                                      |
| [relp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-relp)                                                 | Receives RELP events over a TCP socket                                | [logstash-input-relp](https://github.com/logstash-plugins/logstash-input-relp)                                                        |
| [rss](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-rss)                                                   | Captures the output of command line tools as an event                 | [logstash-input-rss](https://github.com/logstash-plugins/logstash-input-rss)                                                          |
| [s3](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-s3)                                                     | Streams events from files in a S3 bucket                              | [logstash-input-s3](https://github.com/logstash-plugins/logstash-input-s3)                                                            |
| [s3-sns-sqs](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-s3-sns-sqs)                                     | Reads logs from AWS S3 buckets using sqs                              | [logstash-input-s3-sns-sqs](https://github.com/cherweg/logstash-input-s3-sns-sqs)                                                     |
| [salesforce](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-salesforce)                                     | Creates events based on a Salesforce SOQL query                       | [logstash-input-salesforce](https://github.com/logstash-plugins/logstash-input-salesforce)                                            |
| [snmp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-snmp)                                                 | Polls network devices using Simple Network Management Protocol (SNMP) | [logstash-integration-snmp](https://github.com/logstash-plugins/logstash-integration-snmp)                                            |
| [snmptrap](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-snmptrap)                                         | Creates events based on SNMP trap messages                            | [logstash-integration-snmp](https://github.com/logstash-plugins/logstash-integration-snmp)                                            |
| [sqlite](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-sqlite)                                             | Creates events based on rows in an SQLite database                    | [logstash-input-sqlite](https://github.com/logstash-plugins/logstash-input-sqlite)                                                    |
| [sqs](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-sqs)                                                   | Pulls events from an Amazon Web Services Simple Queue Service queue   | [logstash-input-sqs](https://github.com/logstash-plugins/logstash-input-sqs)                                                          |
| [stdin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-stdin)                                               | Reads events from standard input                                      | [logstash-input-stdin](https://github.com/logstash-plugins/logstash-input-stdin)                                                      |
| [stomp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-stomp)                                               | Creates events received with the STOMP protocol                       | [logstash-input-stomp](https://github.com/logstash-plugins/logstash-input-stomp)                                                      |
| [syslog](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-syslog)                                             | Reads syslog messages as events                                       | [logstash-input-syslog](https://github.com/logstash-plugins/logstash-input-syslog)                                                    |
| [tcp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-tcp)                                                   | Reads events from a TCP socket                                        | [logstash-input-tcp](https://github.com/logstash-plugins/logstash-input-tcp)                                                          |
| [twitter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-twitter)                                           | Reads events from the Twitter Streaming API                           | [logstash-input-twitter](https://github.com/logstash-plugins/logstash-input-twitter)                                                  |
| [udp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-udp)                                                   | Reads events over UDP                                                 | [logstash-input-udp](https://github.com/logstash-plugins/logstash-input-udp)                                                          |
| [unix](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-unix)                                                 | Reads events over a UNIX socket                                       | [logstash-input-unix](https://github.com/logstash-plugins/logstash-input-unix)                                                        |
| [varnishlog](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-varnishlog)                                     | Reads from the `varnish` cache shared memory log                      | [logstash-input-varnishlog](https://github.com/logstash-plugins/logstash-input-varnishlog)                                            |
| [websocket](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-websocket)                                       | Reads events from a websocket                                         | [logstash-input-websocket](https://github.com/logstash-plugins/logstash-input-websocket)                                              |
| [wmi](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-wmi)                                                   | Creates events based on the results of a WMI query                    | [logstash-input-wmi](https://github.com/logstash-plugins/logstash-input-wmi)                                                          |
| [xmpp](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-xmpp)                                                 | Receives events over the XMPP/Jabber protocol                         | [logstash-input-xmpp](https://github.com/logstash-plugins/logstash-input-xmpp)                                                        |