﻿---
title: Filter plugins
description: A filter plugin performs intermediary processing on an event. Filters are often applied conditionally depending on the characteristics of the event. The...
url: https://www.elastic.co/docs/reference/logstash/plugins/filter-plugins
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Filter plugins
A filter plugin performs intermediary processing on an event. Filters are often applied conditionally depending on the
characteristics of the event.
The following filter plugins are available below. For a list of Elastic supported plugins, please consult the [Support Matrix](https://www.elastic.co/support/matrix#show_logstash_plugins).

| Plugin                                                                                                                  | Description                                                                                                                | Github repository                                                                                                                 |
|-------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------|
| [age](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-age)                                       | Calculates the age of an event by subtracting the event timestamp from the current timestamp                               | [logstash-filter-age](https://github.com/logstash-plugins/logstash-filter-age)                                                    |
| [aggregate](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-aggregate)                           | Aggregates information from several events originating with a single task                                                  | [logstash-filter-aggregate](https://github.com/logstash-plugins/logstash-filter-aggregate)                                        |
| [alter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-alter)                                   | Performs general alterations to fields that the `mutate` filter does not handle                                            | [logstash-filter-alter](https://github.com/logstash-plugins/logstash-filter-alter)                                                |
| [bytes](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-bytes)                                   | Parses string representations of computer storage sizes, such as "123 MB" or "5.6gb", into their numeric value in bytes    | [logstash-filter-bytes](https://github.com/logstash-plugins/logstash-filter-bytes)                                                |
| [cidr](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-cidr)                                     | Checks IP addresses against a list of network blocks                                                                       | [logstash-filter-cidr](https://github.com/logstash-plugins/logstash-filter-cidr)                                                  |
| [cipher](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-cipher)                                 | Applies or removes a cipher to an event                                                                                    | [logstash-filter-cipher](https://github.com/logstash-plugins/logstash-filter-cipher)                                              |
| [clone](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-clone)                                   | Duplicates events                                                                                                          | [logstash-filter-clone](https://github.com/logstash-plugins/logstash-filter-clone)                                                |
| [csv](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-csv)                                       | Parses comma-separated value data into individual fields                                                                   | [logstash-filter-csv](https://github.com/logstash-plugins/logstash-filter-csv)                                                    |
| [date](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-date)                                     | Parses dates from fields to use as the Logstash timestamp for an event                                                     | [logstash-filter-date](https://github.com/logstash-plugins/logstash-filter-date)                                                  |
| [de_dot](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-de_dot)                                 | Computationally expensive filter that removes dots from a field name                                                       | [logstash-filter-de_dot](https://github.com/logstash-plugins/logstash-filter-de_dot)                                              |
| [dissect](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-dissect)                               | Extracts unstructured event data into fields using delimiters                                                              | [logstash-filter-dissect](https://github.com/logstash-plugins/logstash-filter-dissect)                                            |
| [dns](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-dns)                                       | Performs a standard or reverse DNS lookup                                                                                  | [logstash-filter-dns](https://github.com/logstash-plugins/logstash-filter-dns)                                                    |
| [drop](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-drop)                                     | Drops all events                                                                                                           | [logstash-filter-drop](https://github.com/logstash-plugins/logstash-filter-drop)                                                  |
| [elapsed](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elapsed)                               | Calculates the elapsed time between a pair of events                                                                       | [logstash-filter-elapsed](https://github.com/logstash-plugins/logstash-filter-elapsed)                                            |
| [elastic_integration](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration)       | Provides additional Logstash processing on data from Elastic integrations                                                  | [logstash-filter-elastic_integration](https://github.com/elastic/logstash-filter-elastic_integration)                             |
| [elasticsearch](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elasticsearch)                   | Copies fields from previous log events in Elasticsearch to current events                                                  | [logstash-filter-elasticsearch](https://github.com/logstash-plugins/logstash-filter-elasticsearch)                                |
| [environment](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-environment)                       | Stores environment variables as metadata sub-fields                                                                        | [logstash-filter-environment](https://github.com/logstash-plugins/logstash-filter-environment)                                    |
| [extractnumbers](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-extractnumbers)                 | Extracts numbers from a string                                                                                             | [logstash-filter-extractnumbers](https://github.com/logstash-plugins/logstash-filter-extractnumbers)                              |
| [fingerprint](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-fingerprint)                       | Fingerprints fields by replacing values with a consistent hash                                                             | [logstash-filter-fingerprint](https://github.com/logstash-plugins/logstash-filter-fingerprint)                                    |
| [geoip](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-geoip)                                   | Adds geographical information about an IP address                                                                          | [logstash-filter-geoip](https://github.com/logstash-plugins/logstash-filter-geoip)                                                |
| [grok](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-grok)                                     | Parses unstructured event data into fields                                                                                 | [logstash-filter-grok](https://github.com/logstash-plugins/logstash-filter-grok)                                                  |
| [http](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-http)                                     | Provides integration with external web services/REST APIs                                                                  | [logstash-filter-http](https://github.com/logstash-plugins/logstash-filter-http)                                                  |
| [i18n](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-i18n)                                     | Removes special characters from a field                                                                                    | [logstash-filter-i18n](https://github.com/logstash-plugins/logstash-filter-i18n)                                                  |
| [java_uuid](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-java_uuid)                           | Generates a UUID and adds it to each processed event                                                                       | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/filters/Uuid.java) |
| [jdbc_streaming](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-jdbc_streaming)                 | Enrich events with your database data                                                                                      | [logstash-integration-jdbc](https://github.com/logstash-plugins/logstash-integration-jdbc)                                        |
| [json](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-json)                                     | Parses JSON events                                                                                                         | [logstash-filter-json](https://github.com/logstash-plugins/logstash-filter-json)                                                  |
| [json_encode](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-json_encode)                       | Serializes a field to JSON                                                                                                 | [logstash-filter-json_encode](https://github.com/logstash-plugins/logstash-filter-json_encode)                                    |
| [kv](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-kv)                                         | Parses key-value pairs                                                                                                     | [logstash-filter-kv](https://github.com/logstash-plugins/logstash-filter-kv)                                                      |
| [memcached](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-memcached)                           | Provides integration with external data in Memcached                                                                       | [logstash-filter-memcached](https://github.com/logstash-plugins/logstash-filter-memcached)                                        |
| [metricize](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-metricize)                           | Takes complex events containing a number of metrics and splits these up into multiple events, each holding a single metric | [logstash-filter-metricize](https://github.com/logstash-plugins/logstash-filter-metricize)                                        |
| [metrics](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-metrics)                               | Aggregates metrics                                                                                                         | [logstash-filter-metrics](https://github.com/logstash-plugins/logstash-filter-metrics)                                            |
| [mutate](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-mutate)                                 | Performs mutations on fields                                                                                               | [logstash-filter-mutate](https://github.com/logstash-plugins/logstash-filter-mutate)                                              |
| [prune](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-prune)                                   | Prunes event data based on a list of fields to blacklist or whitelist                                                      | [logstash-filter-prune](https://github.com/logstash-plugins/logstash-filter-prune)                                                |
| [range](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-range)                                   | Checks that specified fields stay within given size or length limits                                                       | [logstash-filter-range](https://github.com/logstash-plugins/logstash-filter-range)                                                |
| [ruby](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-ruby)                                     | Executes arbitrary Ruby code                                                                                               | [logstash-filter-ruby](https://github.com/logstash-plugins/logstash-filter-ruby)                                                  |
| [sleep](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-sleep)                                   | Sleeps for a specified time span                                                                                           | [logstash-filter-sleep](https://github.com/logstash-plugins/logstash-filter-sleep)                                                |
| [split](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-split)                                   | Splits multi-line messages, strings, or arrays into distinct events                                                        | [logstash-filter-split](https://github.com/logstash-plugins/logstash-filter-split)                                                |
| [syslog_pri](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-syslog_pri)                         | Parses the `PRI` (priority) field of a `syslog` message                                                                    | [logstash-filter-syslog_pri](https://github.com/logstash-plugins/logstash-filter-syslog_pri)                                      |
| [threats_classifier](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-threats_classifier)         | Enriches security logs with information about the attacker’s intent                                                        | [logstash-filter-threats_classifier](https://github.com/empow/logstash-filter-threats_classifier)                                 |
| [throttle](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-throttle)                             | Throttles the number of events                                                                                             | [logstash-filter-throttle](https://github.com/logstash-plugins/logstash-filter-throttle)                                          |
| [tld](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-tld)                                       | Replaces the contents of the default message field with whatever you specify in the configuration                          | [logstash-filter-tld](https://github.com/logstash-plugins/logstash-filter-tld)                                                    |
| [translate](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-translate)                           | Replaces field contents based on a hash or YAML file                                                                       | [logstash-filter-translate](https://github.com/logstash-plugins/logstash-filter-translate)                                        |
| [truncate](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-truncate)                             | Truncates fields longer than a given length                                                                                | [logstash-filter-truncate](https://github.com/logstash-plugins/logstash-filter-truncate)                                          |
| [urldecode](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-urldecode)                           | Decodes URL-encoded fields                                                                                                 | [logstash-filter-urldecode](https://github.com/logstash-plugins/logstash-filter-urldecode)                                        |
| [useragent](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-useragent)                           | Parses user agent strings into fields                                                                                      | [logstash-filter-useragent](https://github.com/logstash-plugins/logstash-filter-useragent)                                        |
| [uuid](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-uuid)                                     | Adds a UUID to events                                                                                                      | [logstash-filter-uuid](https://github.com/logstash-plugins/logstash-filter-uuid)                                                  |
| [wurfl_device_detection](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-wurfl_device_detection) | Enriches logs with device information such as brand, model, OS                                                             | [logstash-filter-wurfl_device_detection](https://github.com/WURFL/logstash-filter-wurfl_device_detection)                         |
| [xml](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-xml)                                       | Parses XML into fields                                                                                                     | [logstash-filter-xml](https://github.com/logstash-plugins/logstash-filter-xml)                                                    |