﻿---
title: Codec plugins
description: A codec plugin changes the data representation of an event. Codecs are essentially stream filters that can operate as part of an input or output. The...
url: https://www.elastic.co/docs/reference/logstash/plugins/codec-plugins
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Codec plugins
A codec plugin changes the data representation of an event. Codecs are essentially stream filters that can operate as part
of an input or output.
The following codec plugins are available below. For a list of Elastic supported plugins, please consult the [Support Matrix](https://www.elastic.co/support/matrix#show_logstash_plugins).

| Plugin                                                                                         | Description                                                                   | Github repository                                                                                                                 |
|------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------|
| [avro](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-avro)             | Reads serialized Avro records as Logstash events                              | [logstash-codec-avro](https://github.com/logstash-plugins/logstash-codec-avro)                                                    |
| [cef](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-cef)               | Reads the ArcSight Common Event Format (CEF).                                 | [logstash-codec-cef](https://github.com/logstash-plugins/logstash-codec-cef)                                                      |
| [cloudfront](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-cloudfront) | Reads AWS CloudFront reports                                                  | [logstash-codec-cloudfront](https://github.com/logstash-plugins/logstash-codec-cloudfront)                                        |
| [cloudtrail](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-cloudtrail) | Reads AWS CloudTrail log files                                                | [logstash-codec-cloudtrail](https://github.com/logstash-plugins/logstash-codec-cloudtrail)                                        |
| [collectd](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-collectd)     | Reads events from the `collectd` binary protocol using UDP.                   | [logstash-codec-collectd](https://github.com/logstash-plugins/logstash-codec-collectd)                                            |
| [csv](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-csv)               | Takes CSV data, parses it, and passes it along.                               | [logstash-codec-csv](https://github.com/logstash-plugins/logstash-codec-csv)                                                      |
| [dots](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-dots)             | Sends 1 dot per event to `stdout` for performance tracking                    | [logstash-codec-dots](https://github.com/logstash-plugins/logstash-codec-dots)                                                    |
| [edn](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-edn)               | Reads EDN format data                                                         | [logstash-codec-edn](https://github.com/logstash-plugins/logstash-codec-edn)                                                      |
| [edn_lines](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-edn_lines)   | Reads newline-delimited EDN format data                                       | [logstash-codec-edn_lines](https://github.com/logstash-plugins/logstash-codec-edn_lines)                                          |
| [es_bulk](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-es_bulk)       | Reads the Elasticsearch bulk format into separate events, along with metadata | [logstash-codec-es_bulk](https://github.com/logstash-plugins/logstash-codec-es_bulk)                                              |
| [fluent](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-fluent)         | Reads the `fluentd` `msgpack` schema                                          | [logstash-codec-fluent](https://github.com/logstash-plugins/logstash-codec-fluent)                                                |
| [graphite](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-graphite)     | Reads `graphite` formatted lines                                              | [logstash-codec-graphite](https://github.com/logstash-plugins/logstash-codec-graphite)                                            |
| [gzip_lines](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-gzip_lines) | Reads `gzip` encoded content                                                  | [logstash-codec-gzip_lines](https://github.com/logstash-plugins/logstash-codec-gzip_lines)                                        |
| [java_line](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-java_line)   | Encodes and decodes line-oriented text data                                   | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/codecs/Line.java)  |
| [java_plain](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-java_plain) | Processes text data with no delimiters between events                         | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/codecs/Plain.java) |
| [jdots](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-jdots)           | Renders each processed event as a dot                                         | [core plugin](https://github.com/elastic/logstash/blob/master/logstash-core/src/main/java/org/logstash/plugins/codecs/Dots.java)  |
| [json](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-json)             | Reads JSON formatted content, creating one event per element in a JSON array  | [logstash-codec-json](https://github.com/logstash-plugins/logstash-codec-json)                                                    |
| [json_lines](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-json_lines) | Reads newline-delimited JSON                                                  | [logstash-codec-json_lines](https://github.com/logstash-plugins/logstash-codec-json_lines)                                        |
| [line](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-line)             | Reads line-oriented text data                                                 | [logstash-codec-line](https://github.com/logstash-plugins/logstash-codec-line)                                                    |
| [msgpack](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-msgpack)       | Reads MessagePack encoded content                                             | [logstash-codec-msgpack](https://github.com/logstash-plugins/logstash-codec-msgpack)                                              |
| [multiline](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-multiline)   | Merges multiline messages into a single event                                 | [logstash-codec-multiline](https://github.com/logstash-plugins/logstash-codec-multiline)                                          |
| [netflow](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-netflow)       | Reads Netflow v5 and Netflow v9 data                                          | [logstash-codec-netflow](https://github.com/logstash-plugins/logstash-codec-netflow)                                              |
| [nmap](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-nmap)             | Reads Nmap data in XML format                                                 | [logstash-codec-nmap](https://github.com/logstash-plugins/logstash-codec-nmap)                                                    |
| [plain](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-plain)           | Reads plaintext with no delimiting between events                             | [logstash-codec-plain](https://github.com/logstash-plugins/logstash-codec-plain)                                                  |
| [protobuf](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-protobuf)     | Reads protobuf messages and converts to Logstash Events                       | [logstash-codec-protobuf](https://github.com/logstash-plugins/logstash-codec-protobuf)                                            |
| [rubydebug](https://www.elastic.co/docs/reference/logstash/plugins/plugins-codecs-rubydebug)   | Applies the Ruby Awesome Print library to Logstash events                     | [logstash-codec-rubydebug](https://github.com/logstash-plugins/logstash-codec-rubydebug)                                          |