﻿---
title: Logstash Plugins
description: Logstash has a rich collection of input, filter, codec, and output plugins. Check out the Elastic Support Matrix to see which plugins are supported at...
url: https://www.elastic.co/docs/reference/logstash/plugins
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Logstash Plugins
Logstash has a rich collection of input, filter, codec, and output plugins.
Check out the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins) to see which plugins are supported at various levels.
The plugins make up your Logstash pipeline.
- [**Integration plugins**](https://www.elastic.co/docs/reference/logstash/plugins/plugin-integrations) combine related plugins—inputs, outputs, and sometimes filters and codecs—into one package.
- [**Input plugins**](https://www.elastic.co/docs/reference/logstash/plugins/input-plugins) enable a specific source of events to be read by Logstash.
- [**Filter plugins**](https://www.elastic.co/docs/reference/logstash/plugins/filter-plugins) perform intermediary processing on an event. Filters are often applied conditionally depending on the characteristics of the event.
- [**Codec plugins**](https://www.elastic.co/docs/reference/logstash/plugins/codec-plugins) change the data representation of an event.
  Codecs are essentially stream filters that can operate as part of an input or output.
- [**Output plugins**](https://www.elastic.co/docs/reference/logstash/plugins/output-plugins) send event data to a particular destination.
  Outputs are the final stage in the Logstash event pipeline.