﻿---
title: Cross-plugin concepts and features
description: New section for concepts, features, and behaviours that apply to multiple plugins. List-type URI parameters will automatically expand strings that contain...
url: https://www.elastic.co/docs/reference/logstash/plugin-concepts
products:
  - Logstash
---

# Cross-plugin concepts and features
New section for concepts, features, and behaviours that apply to multiple plugins.

## Space-deliminated URIs in list-type params

List-type URI parameters will automatically expand strings that contain multiple whitespace-delimited URIs into separate entries. This behaviour enables the expansion of an arbitrary list of URIs from a single Environment- or Keystore-variable.
These plugins and options support this functionality:
- [Elasticsearch input plugin - `hosts`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elasticsearch#plugins-inputs-elasticsearch-hosts)
- [Elasticsearch output plugin - `hosts`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-hosts)
- [Elasticsearch filter plugin - `hosts`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elasticsearch#plugins-filters-elasticsearch-hosts)

You can use this functionality to define an environment variable with multiple whitespace-delimited URIs and use it for the options above.
**Example**
```
ES_HOSTS="es1.example.com es2.example.com:9201 es3.example.com:9201"
```