﻿---
title: Collect Logstash monitoring data with Metricbeat
description: You can use Metricbeat to collect data about Logstash and ship it to the monitoring cluster. The benefit of Metricbeat collection is that the monitoring...
url: https://www.elastic.co/docs/reference/logstash/monitoring-with-metricbeat
products:
  - Logstash
---

# Collect Logstash monitoring data with Metricbeat
You can use Metricbeat to collect data about Logstash and ship it to the monitoring cluster. The benefit of Metricbeat collection is that the monitoring agent remains active even if the Logstash instance does not.
This step requires [Elasticsearch with Metricbeat monitoring setup](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat).
To collect and ship monitoring data:
1. [Disable default collection of monitoring metrics](#disable-default)
2. [Specify the target `cluster_uuid`](#define-cluster__uuid)
3. [Install and configure Metricbeat to collect monitoring data](#configure-metricbeat)

Want to use Elastic Agent instead? Refer to [Collect monitoring data for stack monitoring](https://www.elastic.co/docs/reference/logstash/monitoring-with-elastic-agent).

## Disable default collection of Logstash monitoring metrics

Set the `monitoring.enabled` to `false` in logstash.yml to disable to default monitoring:
```yaml
monitoring.enabled: false
```


## Determine target Elasticsearch cluster

You will need to determine which Elasticsearch cluster that Logstash will bind metrics to in the Stack Monitoring UI by specifying the `cluster_uuid`. When pipelines contain [Elasticsearch output plugins](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch), the `cluster_uuid` is automatically calculated, and the metrics should be bound without any additional settings.
To override automatic values, or if your pipeline does not contain any [Elasticsearch output plugins](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch), you can bind the metrics of Logstash to a specific cluster, by defining the target cluster in the `monitoring.cluster_uuid` setting. in the configuration file (logstash.yml):
```yaml
monitoring.cluster_uuid: PRODUCTION_ES_CLUSTER_UUID
```

Refer to [Elasticsearch cluster stats page](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-stats) to figure out how to get your cluster `cluster_uuid`.

## Install and configure Metricbeat

1. [Install Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) on the same server as Logstash.
2. Enable the `logstash-xpack` module in Metricbeat.
   To enable the default configuration in the Metricbeat `modules.d` directory, run:
   **deb or rpm:**
   ```sh
   metricbeat modules enable logstash-xpack
   ```
   **linux or mac:**
   ```sh
   ./metricbeat modules enable logstash-xpack
   ```
   **win:**
   ```sh
   PS > .\metricbeat.exe modules enable logstash-xpack
   ```
   For more information, see [Specify which modules to run](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat) and [beat module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-beat).
3. Configure the `logstash-xpack` module in Metricbeat.
   The `modules.d/logstash-xpack.yml` file contains these settings:
   ```yaml
     - module: logstash
       metricsets:
         - node
         - node_stats
       period: 10s
       hosts: ["localhost:9600"]
       #username: "user"
       #password: "secret"
       xpack.enabled: true
   ```
   <tip>
   For the best experience with Stack Monitoring, we recommend collecting both `node` and `node_stats` metricsets. Turning off either of these will result in incomplete or missing visualizations.
   </tip>
   Set the `hosts`, `username`, and `password` to authenticate with Logstash.
   By default, the module collects Logstash monitoring data from `localhost:9600`.
   To monitor multiple Logstash instances, specify a list of hosts, for example:
   ```yaml
   hosts: ["http://localhost:9601","http://localhost:9602","http://localhost:9603"]
   ```
   **Elastic security.** The Elastic security features are enabled by default. You must provide a user ID and password so that Metricbeat can collect metrics successfully:
   1. Create a user on the production cluster that has the `remote_monitoring_collector` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles).
2. Add the `username` and `password` settings to the module configuration file (`logstash-xpack.yml`).
4. Optional: Disable the system module in the Metricbeat.
   By default, the [system module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-system) is enabled. The information it collects, however, is not shown on the **Stack Monitoring** page in Kibana. Unless you want to use that information for other purposes, run the following command:
   ```sh
   metricbeat modules disable system
   ```
5. Identify where to send the monitoring data.
   <tip>
   In production environments, we strongly recommend using a separate cluster (referred to as the *monitoring cluster*) to store the data. Using a separate monitoring cluster prevents production cluster outages from impacting your ability to access your monitoring data. It also prevents monitoring activities from impacting the performance of your production cluster.
   </tip>
   For example, specify the Elasticsearch output information in the Metricbeat configuration file (`metricbeat.yml`):
   ```yaml
   output.elasticsearch:
     # Array of hosts to connect to.
     hosts: ["http://es-mon-1:9200", "http://es-mon2:9200"] 

     # Optional protocol and basic auth credentials.
     #protocol: "https"
     #username: "elastic"
     #password: "changeme"
   ```
   If you configured the monitoring cluster to use encrypted communications, you must access it via HTTPS. For example, use a `hosts` setting like `https://es-mon-1:9200`.
   <important>
   The Elasticsearch monitoring features use ingest pipelines, therefore the cluster that stores the monitoring data must have at least one ingest node.
   </important>
   **Elastic security.** The Elastic security features are enabled by default. You must provide a user ID and password so that Metricbeat can send metrics successfully:
   1. Create a user on the monitoring cluster that has the `remote_monitoring_agent` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles). Alternatively, use the `remote_monitoring_user` [built-in user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
   <tip>
   If you’re using index lifecycle management, the remote monitoring user requires additional privileges to create and read indices. For more information, see `<<feature-roles>>`.
   </tip>
2. Add the `username` and `password` settings to the Elasticsearch output information in the Metricbeat configuration file.
   For more information about these configuration options, see [Configure the Elasticsearch output](https://www.elastic.co/docs/reference/beats/metricbeat/elasticsearch-output).
6. [Start Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-starting) to begin collecting monitoring data.
7. [View the monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data).

Your monitoring setup is complete.