﻿---
title: Monitoring Logstash with Elastic Agent
description: You can use Elastic Agent to collect data about Logstash and ship it to the monitoring cluster. When you use Elastic Agent collection, the monitoring...
url: https://www.elastic.co/docs/reference/logstash/monitoring-logstash-with-elastic-agent
products:
  - Logstash
---

# Monitoring Logstash with Elastic Agent
You can use Elastic Agent to collect data about Logstash and ship it to the monitoring cluster. When you use Elastic Agent collection, the monitoring agent remains active even if the Logstash instance does not. Plus you have the option to manage all of your monitoring agents from a central location in Fleet.
Elastic Agent gives you a single, unified way to add monitoring for logs, metrics, and other types of data to a host. Each agent has a single policy you can update to add integrations for new data sources, security protections, and more.
You can use Elastic Agent to collect Logstash monitoring data on:
- [Elastic Cloud or self-managed dashboards](https://www.elastic.co/docs/reference/logstash/dashboard-monitoring-with-elastic-agent). Elastic Agent collects monitoring data from your Logstash instance, sends it directly to your monitoring cluster, and shows the data in Logstash dashboards. Logstash dashboards include an extended range of metrics, including plugin drilldowns, and plugin specific dashboards for the dissect filter, the grok filter, and the elasticsearch output.
- [Elastic Cloud dashboards (serverless)](https://www.elastic.co/docs/reference/logstash/serverless-monitoring-with-elastic-agent). Elastic Agent collects monitoring data from your Logstash instance, sends it to [Elastic serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless), and shows the data in Logstash dashboards in [Elastic Observability](https://www.elastic.co/docs/solutions/observability). Logstash dashboards include an extended range of metrics, including plugin drilldowns, and plugin specific dashboards for the dissect filter, the grok filter, and the elasticsearch output.
- [Elastic Stack monitoring](https://www.elastic.co/docs/reference/logstash/monitoring-with-elastic-agent). Use the Elastic Stack monitoring features to gain insight into the health of Logstash instances running in your environment.