﻿---
title: Getting started with Logstash
description: This section guides you through the process of installing Logstash and verifying that everything is running properly. After learning how to stash your...
url: https://www.elastic.co/docs/reference/logstash/getting-started-with-logstash
products:
  - Logstash
---

# Getting started with Logstash
This section guides you through the process of installing Logstash and verifying that everything is running properly.
After learning how to stash your first event, you can go on to create a more advanced pipeline that takes Apache web logs as input, parses the logs, and writes the parsed data to an Elasticsearch cluster.
Then you learn how to stitch together multiple input and output plugins to unify data from a variety of disparate sources.
This section includes these topics:
- [Java (JVM) version](#ls-jvm)
- [Installing Logstash](https://www.elastic.co/docs/reference/logstash/installing-logstash)
- [Stashing Your First Event](https://www.elastic.co/docs/reference/logstash/first-event)
- [Parsing Logs with Logstash](https://www.elastic.co/docs/reference/logstash/advanced-pipeline)
- [Stitching Together Multiple Input and Output Plugins](https://www.elastic.co/docs/reference/logstash/multiple-input-output-plugins)


### Java (JVM) version

Logstash requires one of these versions:
- Java 17
- Java 21 (default).

Use the [official Oracle distribution](http://www.oracle.com/technetwork/java/javase/downloads/index.html) or an open-source distribution, such as [OpenJDK](http://openjdk.java.net/). The [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_jvm) is the official word on supported versions across releases.
<admonition title="Bundled JDK">
  Logstash offers architecture-specific [downloads](https://www.elastic.co/downloads/logstash) that include Adoptium Eclipse Temurin 21, a long term support (LTS) release of the JDK.Use the LS_JAVA_HOME environment variable if you want to use a JDK other than the version that is bundled. If you have the LS_JAVA_HOME environment variable set to use a custom JDK, Logstash will continue to use the JDK version you have specified, even after you upgrade.
</admonition>


#### Check your Java version

Run this command:
```shell
java -version
```

On systems with Java installed, this command produces output similar to:
```shell
openjdk version "17.0.12" 2024-07-16
OpenJDK Runtime Environment Temurin-17.0.12+7 (build 17.0.12+7)
OpenJDK 64-Bit Server VM Temurin-17.0.12+7 (build 17.0.12+7, mixed mode)
```


#### `LS_JAVA_HOME`

Logstash includes a bundled JDK which has been verified to work with each specific version of Logstash, and generally provides the best performance and reliability. If you need to use a JDK other than the bundled version, then set the `LS_JAVA_HOME` environment variable to the version you want to use.
On some Linux systems, you may need to have the `LS_JAVA_HOME` environment exported before installing Logstash, particularly if you installed Java from a tarball. Logstash uses Java during installation to automatically detect your environment and install the correct startup method (SysV init scripts, Upstart, or systemd). If Logstash is unable to find the `LS_JAVA_HOME` environment variable during package installation, you may get an error message, and Logstash will not start properly.

#### Update JDK settings when upgrading from Logstash 7.11.x (or earlier)

Logstash uses JDK 21 by default.
If you are upgrading from Logstash 7.11.x (or earlier), you need to update Java settings in `jvm.options` and `log4j2.properties`.

##### Updates to `jvm.options`

In the `config/jvm.options` file, remove all CMS related flags:
```shell
## GC configuration
-XX:+UseConcMarkSweepGC
-XX:CMSInitiatingOccupancyFraction=75
-XX:+UseCMSInitiatingOccupancyOnly
```

For more information about how to use `jvm.options`, please refer to [JVM settings](https://www.elastic.co/docs/reference/logstash/jvm-settings).

##### Updates to `log4j2.properties`

In the `config/log4j2.properties`:
- Replace properties that start with `appender.rolling.avoid_pipelined_filter.*` with:
  ```shell
  appender.rolling.avoid_pipelined_filter.type = PipelineRoutingFilter
  ```
- Replace properties that start with `appender.json_rolling.avoid_pipelined_filter.*` with:
  ```shell
  appender.json_rolling.avoid_pipelined_filter.type = PipelineRoutingFilter
  ```
- Replace properties that start with `appender.routing.*` with:
  ```shell
  appender.routing.type = PipelineRouting
  appender.routing.name = pipeline_routing_appender
  appender.routing.pipeline.type = RollingFile
  appender.routing.pipeline.name = appender-${ctx:pipeline.id}
  appender.routing.pipeline.fileName = ${sys:ls.logs}/pipeline_${ctx:pipeline.id}.log
  appender.routing.pipeline.filePattern = ${sys:ls.logs}/pipeline_${ctx:pipeline.id}.%i.log.gz
  appender.routing.pipeline.layout.type = PatternLayout
  appender.routing.pipeline.layout.pattern = [%d{ISO8601}][%-5p][%-25c] %m%n
  appender.routing.pipeline.policy.type = SizeBasedTriggeringPolicy
  appender.routing.pipeline.policy.size = 100MB
  appender.routing.pipeline.strategy.type = DefaultRolloverStrategy
  appender.routing.pipeline.strategy.max = 30
  ```