﻿---
title: Collect Logstash monitoring data for dashboards
description: Elastic Agent collects monitoring data from your Logstash instance, sends it directly to your monitoring cluster, and shows the data in Logstash dashboards...
url: https://www.elastic.co/docs/reference/logstash/dashboard-monitoring-with-elastic-agent
products:
  - Logstash
---

# Collect Logstash monitoring data for dashboards
Elastic Agent collects monitoring data from your Logstash instance, sends it directly to your monitoring cluster, and shows the data in Logstash dashboards.
You can enroll Elastic Agent in [Fleet](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent) for management from a central location, or you can run [Elastic Agent standalone](https://www.elastic.co/docs/reference/fleet/install-standalone-elastic-agent).
**Prerequisites**
Complete these steps as you prepare to collect and ship monitoring data for dashboards:
<dropdown title="Disable default collection of Logstash monitoring metrics">
  Set `monitoring.enabled` to `false` in logstash.yml to disable default collection:
  ```yaml
  monitoring.enabled: false
  ```
</dropdown>

<dropdown title="Specify the target cluster_uuid (optional)">
  To bind the metrics of Logstash to a specific cluster, optionally define the `monitoring.cluster_uuid` in the configuration file (logstash.yml):
  ```yaml
  monitoring.cluster_uuid: PRODUCTION_ES_CLUSTER_UUID
  ```
</dropdown>

<dropdown title="Grant agent access to Elasticsearch (standalone agent only)">
  Minimal permissions required to send Logstash monitoring data to Elasticsearch:
  - `monitor` cluster privilege
  - `auto_configure` and `create_doc` index privileges on `logs-*` and `metrics-*` indices.
  See [Grant standalone Elastic Agents access to Elasticsearch](https://www.elastic.co/docs/reference/fleet/grant-access-to-elasticsearch)
</dropdown>


## Install and configure Elastic Agent

Install and configure Elastic Agent to collect Logstash monitoring data for dashboards. We’ll walk you through the process in these steps:
- [Add the Elastic Agent Logstash integration to monitor host logs and metrics](#add-logstash-integration-ead)
- [Install and run an Elastic Agent on your machine](#add-agent-to-fleet-ead)
- [View assets](#view-assets-ead)
- [Monitor Logstash logs and metrics](#view-data-dashboard)

Check out [Installing Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-elastic-agents) in the *Fleet and Elastic Agent Guide* for more info.

### Add the Elastic Agent Logstash integration to monitor host logs and metrics

1. Go to the Kibana home page, and click **Add integrations**.
   
   ![Kibana home page](https://www.elastic.co/docs/reference/logstash/images/kibana-home.png)
2. In the query bar, search for **Logstash** and select the integration to see more details.
3. Click **Add Logstash**.
4. Configure the integration name and add a description (optional).
5. Configure the integration to collect logs.
   - Make sure that **Logs** is turned on if you want to collect logs from your Logstash instance. Be sure that the required settings are correctly configured.
- Under **Logs**, modify the log paths to match your Logstash environment.
6. Configure the integration to collect metrics.
   <tip>
   For the best experience with the Logstash dashboards, we recommend collecting all of the metrics. Turning off metrics will result in incomplete or missing visualizations.
   </tip>
   - Make sure that **Metrics (Elastic Agent)** is turned on (default), and **Metrics (Stack Monitoring)** is turned off.
- Under **Metrics (Elastic Agent)**, make sure the Logstash URL setting points to your Logstash instance URLs. By default, the integration collects Logstash monitoring metrics from `https://localhost:9600`. If that host and port number are not correct, update the `Logstash URL` setting. If you configured Logstash to use encrypted communications and/or a username and password, you must access it via HTTPS, and expand the **Advanced Settings** options, and fill in with the appropriate values for your Logstash instance.
7. Click **Save and continue**. This step takes a minute or two to complete. When it’s done, you’ll have an agent policy that contains a system integration policy for the configuration you just specified.
8. In the popup, click **Add Elastic Agent to your hosts** to open the **Add agent** flyout.
   <tip>
   If you accidentally close the popup, go to **Fleet > Agents** and click **Add agent**.
   </tip>


## Install and run an Elastic Agent on your machine

The **Add agent** flyout has two options: **Enroll in Fleet** and **Run standalone**. Enrolling agents in Fleet (default) provides a centralized management tool in Kibana, reducing management overhead.
<tab-set>
  <tab-item title="Fleet-managed">
    1. When the **Add Agent flyout** appears, stay on the **Enroll in fleet** tab.
    2. Skip the **Select enrollment token** step. The enrollment token you need is already selected.
       <note>
       The enrollment token is specific to the Elastic Agent policy that you just created. When you run the command to enroll the agent in Fleet, you will pass in the enrollment token.
       </note>
    3. Download, install, and enroll the Elastic Agent on your host by selecting your host operating system and following the **Install Elastic Agent on your host** step.
    It takes about a minute for Elastic Agent to enroll in Fleet, download the configuration specified in the policy you just created, and start collecting data.
  </tab-item>

  <tab-item title="Run standalone">
    1. When the **Add Agent flyout** appears, navigate to the **Run standalone** tab.
    2. Configure the agent. Follow the instructions in **Install Elastic Agent on your host**.
    3. After unpacking the binary, replace the `elastic-agent.yml` file with that supplied in the Add Agent flyout on the "Run standalone" tab, replacing the values of `ES_USERNAME` and `ES_PASSWORD` appropriately.
    4. Run `sudo ./elastic-agent install`
  </tab-item>
</tab-set>


## View assets

After you have confirmed enrollment and data is coming in,  click **View assets** to access dashboards related to the Logstash integration.
For traditional Stack Monitoring UI, the dashboards marked **[Logs Logstash]** are used to visualize the logs produced by your Logstash instances, with those marked **[Metrics Logstash]** for metrics dashboards. These are populated with data only if you selected the **Metrics (Elastic Agent)** checkbox.
![Integration assets](https://www.elastic.co/docs/reference/logstash/images/integration-assets-dashboards.png)
A number of dashboards are included to view Logstash as a whole, and dashboards that allow you to drill-down into how Logstash is performing on a node, pipeline and plugin basis.

## Monitor Logstash logs and metrics

From the list of assets, open the **[Metrics Logstash] Logstash overview** dashboard to view overall performance. Then follow the navigation panel to further drill down into Logstash performance.
![The Logstash Overview dashboard in Kibana with various metrics from your monitored Logstash](https://www.elastic.co/docs/reference/logstash/images/integration-dashboard-overview.png)
You can hover over any visualization to adjust its settings, or click the **Edit** button to make changes to the dashboard. To learn more, refer to [Dashboard and visualizations](https://www.elastic.co/docs/explore-analyze/dashboards).