﻿---
title: Sending data to Elasticsearch Serverless
description: When you use Elasticsearch on Elastic Cloud Serverless you don’t need to worry about managing the infrastructure that keeps Elasticsearch distributed...
url: https://www.elastic.co/docs/reference/logstash/connecting-to-serverless
products:
  - Logstash
---

# Sending data to Elasticsearch Serverless
When you use Elasticsearch on Elastic Cloud Serverless you don’t need to worry about managing the infrastructure that keeps Elasticsearch distributed and available. These resources are automated on the serverless platform and are designed to scale up and down with your workload.
<admonition title="Logstash to Elastic Cloud Serverless">
  You’ll use the Logstash [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) to send data to Elastic Cloud Serverless.
  Note these differences between Elasticsearch Serverless and both Elastic Cloud Hosted and self-managed Elasticsearch:
  - Use [**API keys**](/docs/reference/logstash/secure-connection#ls-api-keys) to access Elastic Cloud Serverless from Logstash as it does not support native user authentication.
    Any user-based security settings in your [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) configuration are ignored and may cause errors.
  - Elastic Cloud Serverless uses **data streams** and [data lifecycle management (DLM)](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) instead of index lifecycle management (ILM). Any ILM settings in your [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) configuration are ignored and may cause errors.
  - **Logstash monitoring** is available through the [Logstash Integration](https://github.com/elastic/integrations/blob/main/packages/logstash/_dev/build/docs/README.md) in [Elastic Observability](https://www.elastic.co/docs/solutions/observability) on Elastic Cloud Serverless.
  **Known issue for Logstash to Elasticsearch Serverless.**
  The logstash-output-elasticsearch `hosts` setting defaults to port :9200.
  Set the value to port :443 instead.
</admonition>


## Communication between Logstash and Elasticsearch Serverless

[Elasticsearch Serverless](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/get-started) simplifies safe, secure communication between Logstash and Elasticsearch.
When you configure the Elasticsearch output plugin to use [`cloud_id`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-cloud_id) and an [`api_key`](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-api_key), no additional SSL configuration is needed.
Example:
- `output {elasticsearch { cloud_id => "<cloud id>" api_key => "<api key>" } }`

Note that the value of the [`api_key` option](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-api_key) is in the format `id:api_key`, where `id` and `api_key` are the values returned by the [Create API key API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key).

### Cloud ID

Logstash uses the Cloud ID, found in the Elastic Cloud web console, to build the Elasticsearch and Kibana hosts settings. It is a base64 encoded text value of about 120 characters made up of upper and lower case letters and numbers. If you have several Cloud IDs, you can add a label, which is ignored internally, to help you tell them apart. To add a label, prefix your Cloud ID with a label and a `:` separator in this format "<label>:<cloud-id>".

### API key

When you create an API key for Logstash, select **Logstash** from the **API key format** dropdown.
This option formats the API key in the correct `id:api_key` format required by Logstash.
![API key format dropdown set to Logstash:](https://www.elastic.co/docs/reference/logstash/images/logstash_api_key_format.png)

The UI for API keys may look different depending on the deployment type.

## Using Cloud ID with plugins

The Elasticsearch input, output, and filter plugins, as well as the Elastic_integration filter plugin, support cloud_id in their configurations.
- [Elasticsearch input plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elasticsearch#plugins-inputs-elasticsearch-cloud_id)
- [Elasticsearch filter plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elasticsearch#plugins-filters-elasticsearch-cloud_id)
- [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-cloud_id)
- [Elastic_integration filter plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration#plugins-filters-elastic_integration-cloud_id)


## Using Logstash Central Pipeline Management with Elasticsearch Serverless

This setting in the `logstash.yml` config file can help you get set up to use Central Pipeline management in Elastic Cloud:
- `xpack.management.elasticsearch.cloud_id`

You can use the `xpack.management.elasticsearch.cloud_id` setting as an alternative to `xpack.management.elasticsearch.hosts`.