﻿---
title: Logstash
description: Logstash is an open source data collection engine with real-time pipelining capabilities. Logstash can dynamically unify data from disparate sources and...
url: https://www.elastic.co/docs/reference/logstash
products:
  - Logstash
---

# Logstash
Logstash is an open source data collection engine with real-time pipelining capabilities.
Logstash can dynamically unify data from disparate sources and normalize the data into destinations of your choice.
Cleanse and democratize all your data for diverse advanced downstream analytics and visualization use cases.
While Logstash originally drove innovation in log collection, its capabilities extend well beyond that use case.
Any type of event can be enriched and transformed with a broad array of input, filter, and output plugins, with many native codecs further simplifying the ingestion process.
Logstash accelerates your insights by harnessing a greater volume and variety of data.
<admonition title="Logstash to Elastic Cloud Serverless">
  You’ll use the Logstash [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) to send data to Elastic Cloud Serverless.
  Note these differences between Elasticsearch Serverless and both Elastic Cloud Hosted and self-managed Elasticsearch:
  - Use [**API keys**](/docs/reference/logstash/secure-connection#ls-api-keys) to access Elastic Cloud Serverless from Logstash as it does not support native user authentication.
    Any user-based security settings in your [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) configuration are ignored and may cause errors.
  - Elastic Cloud Serverless uses **data streams** and [data lifecycle management (DLM)](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) instead of index lifecycle management (ILM). Any ILM settings in your [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) configuration are ignored and may cause errors.
  - **Logstash monitoring** is available through the [Logstash Integration](https://github.com/elastic/integrations/blob/main/packages/logstash/_dev/build/docs/README.md) in [Elastic Observability](https://www.elastic.co/docs/solutions/observability) on Elastic Cloud Serverless.
  **Known issue for Logstash to Elasticsearch Serverless.**
  The logstash-output-elasticsearch `hosts` setting defaults to port :9200.
  Set the value to port :443 instead.
</admonition>