﻿---
title: XSOAR connector and action
description: XSOAR connector uses the XSOAR REST API to create Cortex XSOAR incidents. You can create connectors in Stack Management > Connectors or as needed when...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/xsoar-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
---

# XSOAR connector and action
XSOAR connector uses the [XSOAR REST API](https://cortex-panw.stoplight.io/docs/cortex-xsoar-8/m0qlgh9inh4vk-create-or-update-an-incident) to create Cortex XSOAR incidents.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you’re creating a rule. For example:
![XSOAR connector](https://www.elastic.co/docs/reference/kibana/images/xsoar-connector.png)

### Connector configuration

XSOAR connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="URL">
    The XSOAR instance URL.
  </definition>
  <definition term="API key">
    The XSOAR API key for authentication.
    <note>
      If you do not have an API key, refer to [Create a new API key](https://cortex-panw.stoplight.io/docs/cortex-xsoar-8/t09y7hrb5d14m-create-a-new-api-key) to make one for your XSOAR instance.
    </note>
  </definition>
  <definition term="API key id">
    The XSOAR API key ID for authentication. (Mandatory for cloud instance users.)
  </definition>
</definitions>


## Test connectors

You can test connectors as you’re creating or editing the connector in Kibana. For example:
![XSOAR params test](https://www.elastic.co/docs/reference/kibana/images/xsoar-params-test.png)
XSOAR actions have the following configuration properties.
<definitions>
  <definition term="Name">
    The incident name.
  </definition>
  <definition term="Playbook">
    The playbook to associate with the incident.
  </definition>
  <definition term="Start investigation">
    If turned on, will automatically start the investigation process after the incident is created.
  </definition>
  <definition term="Severity">
    The severity of the incident. Can be `Unknown`, `Informational`, `Low`, `Medium`, `High` or `Critical`.
    <note>
      Turn on `Keep severity from rule` to create an incident that inherits the rule's severity.
    </note>
  </definition>
  <definition term="Body">
    A JSON payload that includes additional parameters to be included in the API request.
    ```json
    {
      "details": "This is an example incident",
      "type": "Unclassified"
    }
    ```
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.