﻿---
title: Webhook connector and action
description: The Webhook connector uses axios to send a request to a web service. You can create connectors in Stack Management > Connectors or as needed when you’re...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Webhook connector and action
The Webhook connector uses [axios](https://github.com/axios/axios) to send a request to a web service.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you’re creating a rule. For example:
![Webhook connector](https://www.elastic.co/docs/reference/kibana/images/webhook-connector.png)


### Connector configuration

Webhook connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="Method">
    The HTTP method to send a request to a web service:
    - `POST` (default)
    - `PUT`
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> `PATCH`
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> `GET`
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> `DELETE`
  </definition>
  <definition term="URL">
    The request URL. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts.
  </definition>
  <definition term="Authentication">
    The authentication type: none, basic, SSL, or <applies-to>Elastic Stack: Generally available since 9.2</applies-to> OAuth 2.0 authentication.
    <definitions>
      <definition term="Basic">
        If you choose basic authentication, you must provide a user name and password.
      </definition>
      <definition term="SSL">
        If you choose SSL authentication, you must provide SSL server certificate authentication data in a CRT and key file format or a PFX file format. You can also optionally provide a passphrase if the files are password-protected.
      </definition>
      <definition term="OAuth 2.0 authentication Elastic Stack: Generally available since 9.2">
        If you choose OAuth 2.0 authentication, you must provide an access token URL, client ID, and client secret. Specifying the [access token scope](https://datatracker.ietf.org/doc/html/rfc6749#section-3.3) is optional. You also have the option to specify additional parameters that your authentication provider might require.
      </definition>
    </definitions>
  </definition>
  <definition term="HTTP headers (optional)">
    A custom set of HTTP headers that you can send with API requests.
    <definitions>
      <definition term="Config">
        If you choose the config type, values in headers will be sent as plain text in requests.
      </definition>
      <definition term="Secret Elastic Stack: Generally available since 9.2">
        If you choose the secret type, values in your headers will be encrypted in requests.
      </definition>
    </definitions>
  </definition>
  <definition term="Certificate authority (optional)">
    A certificate authority (CA) that the connector can trust, for example to sign and validate server certificates. This option is available for all authentication types.
    <definitions>
      <definition term="CA file">
        The certificate authority file.
      </definition>
      <definition term="Verification mode">
        Controls the certificate verification.
        - Use `full` to validate that the certificate has an issue date within the `not_before` and `not_after` dates, chains to a trusted certificate authority, and has a hostname or IP address that matches the names within the certificate.
        - Use `certificate` to validate the certificate and verifies that it is signed by a trusted authority; this option does not check the certificate hostname.
        - Use `none` to skip certificate validation.
      </definition>
    </definitions>
  </definition>
</definitions>


## Test connectors

You can test connectors as you’re creating or editing the connector in Kibana. For example:
![Webhook params test](https://www.elastic.co/docs/reference/kibana/images/webhook-params-test.png)

Webhook actions have the following properties.
<definitions>
  <definition term="Body">
    A JSON payload sent to the request URL using the `POST`, `PUT`, or `PATCH` HTTP methods. For example:
    ```text
    {
      "short_description": "{{context.rule.name}}",
      "description": "{{context.rule.description}}",
      ...
    }
    ```
  </definition>
</definitions>

Mustache template variables (the text enclosed in double braces, for example, `context.rule.name`) have their values escaped, so that the final JSON will be valid (escaping double quote characters). For more information on Mustache template variables, refer to [Actions](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#defining-rules-actions-details).

## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.