﻿---
title: VirusTotal connector
description: The VirusTotal connector communicates with the VirusTotal API for file scanning, URL analysis, and threat intelligence lookups. You can create connectors...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/virustotal-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# VirusTotal connector
The VirusTotal connector communicates with the VirusTotal API for file scanning, URL analysis, and threat intelligence lookups.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

VirusTotal connectors have the following configuration properties:
<definitions>
  <definition term="API Key">
    The VirusTotal API key for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The VirusTotal connector has the following actions:
<definitions>
  <definition term="Scan File Hash">
    Look up a file hash (MD5, SHA-1, or SHA-256) to get scan results.
    - **Hash** (required): File hash (minimum 32 characters).
  </definition>
  <definition term="Scan URL">
    Submit a URL for analysis and get scan results.
    - **URL** (required): URL to scan.
  </definition>
  <definition term="Submit File">
    Submit a file for analysis.
    - **File** (required): Base64-encoded file content.
    - **Filename** (optional): Original filename.
  </definition>
  <definition term="Get IP Report">
    Get reputation and details about an IP address.
    - **IP** (required): IPv4 address.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the VirusTotal connector, you need an API key:
1. Go to [VirusTotal](https://www.virustotal.com/).
2. Sign up for an account or log in.
3. Navigate to your [API Key page](https://www.virustotal.com/gui/user/apikey).
4. Copy your API key. For free accounts, you'll have rate limits. Consider upgrading to a premium account for higher limits.
5. Copy the API key to configure the connector.