﻿---
title: URLVoid connector
description: The URLVoid connector communicates with the URLVoid API to check domain and URL reputation using multi-engine scanning. You can create connectors in Stack...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/urlvoid-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# URLVoid connector
The URLVoid connector communicates with the URLVoid API to check domain and URL reputation using multi-engine scanning.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

URLVoid connectors have the following configuration properties:
<definitions>
  <definition term="API Key">
    The URLVoid API key for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The URLVoid connector has the following actions:
<definitions>
  <definition term="Scan Domain">
    Scan a domain name for reputation and malicious activity.
    - **Domain** (required): The domain name to scan.
  </definition>
  <definition term="Check URL">
    Check a full URL for reputation and safety.
    - **URL** (required): The URL to check.
  </definition>
  <definition term="Get Domain Info">
    Retrieve detailed information about a domain including registrar and creation date.
    - **Domain** (required): The domain name.
  </definition>
  <definition term="Scan Domain Stats">
    Get API usage statistics including queries remaining and queries used.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the URLVoid connector, you need an API key:
1. Go to [URLVoid](https://www.urlvoid.com/).
2. Sign up for an API account.
3. Choose an API plan that suits your needs.
4. After purchase, you'll receive your API key via email.
5. Copy the API key to configure the connector.